%
% file: test_mcclear.m
%
% Example of calling McClear service.
%
% This file contains only 1 TEST. You can execute it with "Run" button in "EDITOR" toolbar.
%
% authors - date:
% Christophe Vernay, Solais - 2018
% Laurent Saboret, Transvalor - 2018

clear all; close all; clc

%% Inputs for SoDa requests

% Test location.
% Feel free to select a location in Meteosat field of view http://www.soda-pro.com/documents/10157/326334/msg_resolution_large.jpg.
location = 'Carpentras';
lat = 44.083;   % latitude [deg]
lon = 5.059;    % longitude [deg]
h = 100;        % elevation [m] -999 for default elevation from SRTM elevation database

% Test period.
% Feel free to change these values.
% Note: Days 2005-01-11 and 2005-01-12 are missing in Apollo clouds.
year1=2018; month1=05; day1=01;
year2=2018; month2=05; day2=10;
%
yyyymmdd1 = sprintf('%04d-%02d-%02d', year1, month1, day1); % compute test period as YYYY-MM-DD
yyyymmdd2 = sprintf('%04d-%02d-%02d', year2, month2, day2);
%
jd1 = date2jd(year1, month1, day1,  0, 15, 0); % get first and last steps as julian days
jd2 = date2jd(year2, month2, day2, 24,  0, 0);

% Select time step
duration = 15;  % time step 'd', 'h', 15 or 1 [min]

% TODO Please enter your email below (requires an account on www.soda-pro.com)
email_address = 'laurent.saboret@transvalor.com' ;   % email SoDa

%% Processus

% Running McClear service using wget
MC = mcclear_wget(email_address, [lat lon h], yyyymmdd1, yyyymmdd2, duration);

% Plot Gc
figure
set(gcf,'position',[100 100 1200 600]) % left, bottom, width, height
jds = [jd1:duration/1440:jd2]; % list of time steps as julian days
[years, months, days, hours, minutes, seconds] = jd2date(jds); % list of time steps as gregorian dates
datenums = datenum([years' months' days' hours' minutes' seconds']); % list of time steps as datenums
plot(datenums, MC.GHI(:))
ticks = [round(datenums(1)):round(datenums(end))]; % 1 tick per day
set(gca, 'XTick', ticks);
datetick('x','yyyy/mm/dd','keepticks','keeplimits');
fig_title=sprintf('Gc %d min (Wh/m2) at %s (%.3f, %.3f) from %s to %s', duration, location, lat, lon, yyyymmdd1, yyyymmdd2);
title(fig_title);

% Plot BNc
figure
set(gcf,'position',[100 100 1200 600]) % left, bottom, width, height
jds = [jd1:duration/1440:jd2]; % list of time steps as julian days
[years, months, days, hours, minutes, seconds] = jd2date(jds); % list of time steps as gregorian dates
datenums = datenum([years' months' days' hours' minutes' seconds']); % list of time steps as datenums
plot(datenums, MC.BNI(:))
ticks = [round(datenums(1)):round(datenums(end))]; % 1 tick per day
set(gca, 'XTick', ticks);
datetick('x','yyyy/mm/dd','keepticks','keeplimits');
fig_title=sprintf('BNc %d min (Wh/m2) at %s (%.3f, %.3f) from %s to %s', duration, location, lat, lon, yyyymmdd1, yyyymmdd2);
title(fig_title);

