function Ia = Aima(I,p,sz,dg,doAR)

z = p(1);
r = p(2);
tx = p(3);
ty = p(4);

if (nargin < 3)
    sz = [];
end
if (isempty(sz))
    sz = size(I).*[z z];
end

if (nargin < 4)
    dg = 7;
end

if (nargin < 5)
    doAR = 1;
end

[nl,nc] = size(I);

cr = cos(r);
sr = sin(r);

T = [z*cr z*sr ty ; -z*sr z*cr tx];

if (doAR == 1)

    hx = 1;
    rx = 0;

    if (z < 1)

        % ssech
        r = 1/z;
        rayon = ceil(8*r);
        x = [-rayon:rayon];
        h = sinc(x/r)/r;
        nh = length(h);

        h = h.*blackman(nh)';

        hx = h /sum(h(:));
        rx = rayon;
    end

    pad = rx;
    Ip = padarray(I,[rx,rx],'symmetric','both');
    Ip = conv2(hx,hx,Ip,'same');
    I = Ip(rx+[1:nl],rx+[1:nc]);

end

Ia = bspline_affine(I,T,sz,dg);



