function [lon,lat] = MSG_loc_dir(qx, qy, h, lon_sat)

opt = 0;
if (nargin < 3)
    h = 0;
    opt = 1;
end
if (nargin < 4)
    lon_sat = 0;
end

r_pol = 6356.5838;
r_eq = 6378.1690;
hsat = 42164;
npy = 3712; 
npx = 3712;
fac = 781648343.404;
% fac = 781648343;
deltaX = -2^16/fac;
deltaY = -2^16/fac;
k1 = (r_eq/r_pol)^2;
k2 = 1737121856;

px = npx-qx+1-0.5;
py = npy-qy+1-0.5;

x = (px-npx/2)*deltaX;
y = (py-npy/2)*deltaY;

cosx = cos(x);
cosy = cos(y);
siny = sin(y);
siny2 = siny.^2;
cosy2 = cosy.^2;

sd = sqrt((hsat*cosx.*cosy).^2 - (cosy2 + k1*siny2)*k2);
sn = (hsat*cosx.*cosy-sd)./(cosy2 + k1*siny2);
s1 = hsat - sn.*cosx.*cosy;
s2 = sn.*sin(x).*cosy;
s3 = -sn.*siny;
sxy = sqrt(s1.^2 + s2.^2);

lon = atan(s2./s1)*180/pi + lon_sat;
lat = atan(k1*s3./sxy)*180/pi;


