function [qx,qy] = MSG_errloc_inv(lon, lat, h, lon_sat)

if (nargin < 3)
    h = 0;
end
if (nargin < 4)
    lon_sat = 0;
end

r_pol = 6356.5838;
r_eq = 6378.1690;
hsat = 42164;
npy = 3712; 
npx = 3712;
fac = 781648343.404;

deltaX = -2^16/fac;
deltaY = -2^16/fac;
k1 = (r_pol/r_eq)^2;
k2 = (r_eq^2-r_pol^2)/r_pol^2;
lambda_sat = lon_sat*pi/180;

lambda_e = lon*pi/180;
phi_e = atan(tan(lat*pi/180)*k1);
cos_phi_e = cos(phi_e);

re = r_pol./sqrt(1-k2*cos_phi_e.^2) + h;

r1 = hsat-re.*cos_phi_e.*cos(lambda_e-lambda_sat);
r2 = -re.*cos_phi_e.*sin(lambda_e-lambda_sat);
r3 = re.*sin(phi_e);

x = atan(-r2./r1);
y = asin(-r3./sqrt(r1.^2+r2.^2+r3.^2));

px = x/deltaX + npx/2+0.5;
py = y/deltaY + npy/2+0.5;

qx = npx-px+1;
qy = npy-py+1;
