function I = agglo_I(I_i, t_i, t, eps_dt)
% e.g. var_GRD_h = agglo_I(var_GRD,tu,tu_1h);
% NB: in irradiation! If I_i is in irradiance, do not forget to divide I 
% by length(t_i)/length(t), e.g. divide by 1440/48 = 30 to go from 1 min to
% 30 min irradiances

if (nargin == 2)
   I = t_i*I;
   return
end

nt = length(t);
% I_i(isnan(I_i)) = 0;

nd = size(I_i,2);

I = zeros(nt,nd);


k = 1;
ind_i = find(t_i<=t(k));
I(k,:) = sum(I_i(ind_i,:),1);

if (length(t)>=2)
    dt = t(2)-t(1);
    if (nargin < 4)
        eps_dt = dt/100;
    end
    for k = 2:nt,
        ind_i = find((t_i>t(k-1)+eps_dt)&(t_i<=t(k)+eps_dt));
        I(k,:) = sum(I_i(ind_i,:),1);
    end
end

