function [R_a, d_a, nbm_a] = agglo_m2y(R_m, d_m, seuil_rc)

if (nargin < 3)
    seuil_rc = 1.2;
end

ka = 0;
a_ka = -1;
m_ka = -1;

nm = size(R_m,1);
nd = size(R_m,2);

na = length(unique(d_m(:,1)));
R_a = zeros(na, nd);
d_a = zeros(na, 1);
nbm_a = zeros(na, 1);

for m = 1:nm,
    
    a = d_m(m,1);
    
    idx_m = find(d_a==a);
    
    if (isempty(idx_m))
        ka = ka + 1;
        a_ka = a;
        d_a(ka,:) = a;
        idx_m = ka;
    end
    if (length(idx_m)>1)
        error('impossible');
    end
    
    v = R_m(m,:);
    if (isempty(find(isnan(v))))        
        nbm_a(idx_m, 1) = nbm_a(idx_m, 1) + 1;        
        R_a(idx_m,:) = R_a(idx_m,:) + v;        
    end
    
end

nbm_a = nbm_a(1:ka,:);
d_a = d_a(1:ka,:);

R_ac = R_a(1:ka,:);

rc = 12./nbm_a;
rc(rc>seuil_rc) = nan;
R_a = R_ac.*repmat(rc,1,nd);

nbm_a(:,2) = rc;


