function [F,b] = calc_CDF(v,w)

if (nargin < 2)
    b = [];
end

v = v(:);
v(isnan(v)) = [];
nv = length(v);

two_cdf = 0;
if (nargin==2)
    w = w(:);
    w(isnan(w)) = [];
    nw = length(w);
    two_cdf = 1;
end

if (two_cdf==0)
    b = [-Inf ; unique(v) ; Inf];
else
    b = [-Inf ; unique([v;w]) ; Inf];
end
if (~isinf(b(1)))
    b = [-Inf ; b];
end

nb = length(b);

hc = histc(v,b);
F = cumsum(hc)/sum(hc);

if (two_cdf==1)
    hc = histc(w,b);
    F(:,2) = cumsum(hc)/sum(hc);
end

t = (max(abs(diff(circshift(F,[1 0]),1,1)),[],2)<eps);
if (any(t))
    F(t,:) = [];
    b(t) = [];
end

F = F(1:end-1,:);
b = b(1:end-1);

if (nargout == 0)
    plot(b,F)
end

% %% test
% Ft = zeros(size(F));
% for kb = 1:length(b),
%     idx = find(v <= b(kb));
%     Ft(kb,1) = length(idx)/nv;
%     idx = find(w <= b(kb));
%     Ft(kb,2) = length(idx)/nw;
% end

