function [a,b,c,d,e,kbin] = calc_a_b_c_d_e(epsilon, Delta, thetaS)

sz = size(epsilon);
epsilon = epsilon(:);
Delta = Delta(:);
thetaS = thetaS(:);

ok = (~isnan(epsilon))&(~isnan(Delta))&(thetaS<pi/2);

bin_epsilon_0 = [1 1.065 1.230 1.5 1.95 2.8 4.5 6.2];
bin_epsilon_1 = [1.065 1.230 1.5 1.95 2.8 4.5 6.2 inf];
nbin = 8;

epsilon = epsilon(ok);
Delta = Delta(ok);
thetaS = thetaS(ok);
kbin_epsilon = ones(size(epsilon));

for kb = 1:nbin,
    b = (epsilon>=bin_epsilon_0(kb))&(epsilon<bin_epsilon_1(kb));
    kbin_epsilon(b) = kb;
end
kbin_epsilon(epsilon<1-eps)=nan;

%%
tab_a = [...
    1.3525   -0.2576   -0.2690   -1.4366 ; ...
   -1.2219   -0.7730    1.4148    1.1016 ; ...
   -1.1000   -0.2515    0.8952    0.0156 ; ...
   -0.5484   -0.6654   -0.2672    0.7117 ; ...
   -0.6000   -0.3566   -2.5000    2.3250 ; ...
   -1.0156   -0.3670    1.0078    1.4051 ; ...
   -1.0000    0.0211    0.5025   -0.5119 ; ...
   -1.0500    0.0289    0.4260    0.3590];

a1 = tab_a(kbin_epsilon,1);
a2 = tab_a(kbin_epsilon,2);
a3 = tab_a(kbin_epsilon,3);
a4 = tab_a(kbin_epsilon,4);
a = nan(sz);
a(ok) = a1 + a2.*thetaS + Delta.*(a3+a4.*thetaS);

%%
tab_b = [...
   -0.7670    0.0007    1.2734   -0.1233 ; ...
   -0.2054    0.0367   -3.9128    0.9156 ; ...
    0.2782   -0.1812   -4.5000    1.1766 ; ...
    0.7234   -0.6219   -5.6812    2.6297 ; ...
    0.2937    0.0496   -5.6812    1.8415 ; ...
    0.2875   -0.5328   -3.8500    3.3750 ; ...
   -0.3000    0.1922    0.7023   -1.6317 ; ...
   -0.3250    0.1156    0.7781    0.0025];
   
b1 = tab_b(kbin_epsilon,1);
b2 = tab_b(kbin_epsilon,2);
b3 = tab_b(kbin_epsilon,3);
b4 = tab_b(kbin_epsilon,4);
b = nan(sz);
b(ok) = b1 + b2.*thetaS + Delta.*(b3+b4.*thetaS);

%%
tab_c = [...
    2.8000    0.6004    1.2375    1.0000 ; ...
    6.9750    0.1774    6.4477   -0.1239 ; ...
   24.7219  -13.0812  -37.7000   34.8438 ; ...
   33.3389  -18.3000  -62.2500   52.0781 ; ...
   21.0000   -4.7656  -21.5906    7.2492 ; ...
   14.0000   -0.9999   -7.1406    7.5469 ; ...
   19.0000   -5.0000    1.2438   -1.9094 ; ...
   31.0625  -14.5000  -46.1148   55.3750 ];

c1 = tab_c(kbin_epsilon,1);
c2 = tab_c(kbin_epsilon,2);
c3 = tab_c(kbin_epsilon,3);
c4 = tab_c(kbin_epsilon,4);
c = nan(sz);
c_ok = c1 + c2.*thetaS + Delta.*(c3+c4.*thetaS);
k = (kbin_epsilon==1);
c_ok(k) = exp((Delta(k).*(c1(k)+c2(k).*thetaS(k))).^c3(k))-c4(k);
c(ok) = c_ok;

%%
tab_d = [...
    1.8734    0.6297    0.9738    0.2809; ...
   -1.5798   -0.5081   -1.7812    0.1080; ...
   -5.0000    1.5218    3.9229   -2.6204; ...
   -3.5000    0.0016    1.1477    0.1062; ...
   -3.5000   -0.1554    1.4062    0.3988; ...
   -3.4000   -0.1078   -1.0750    1.5702; ...
   -4.0000    0.0250    0.3844    0.2656; ...
   -7.2312    0.4050   13.3500    0.6234];

d1 = tab_d(kbin_epsilon,1);
d2 = tab_d(kbin_epsilon,2);
d3 = tab_d(kbin_epsilon,3);
d4 = tab_d(kbin_epsilon,4);
d = nan(sz);
d_ok = d1 + d2.*thetaS + Delta.*(d3+d4.*thetaS);
k = (kbin_epsilon==1);
d_ok(k) = -exp(Delta(k).*(d1(k)+d2(k).*thetaS(k)))+d3(k)+Delta(k).*d4(k);
d(ok) = d_ok;

%%
tab_e = [...
    0.0356   -0.1246   -0.5718    0.9938; ...
    0.2624    0.0672   -0.2190   -0.4285; ...
   -0.0156    0.1597    0.4199   -0.5562; ...
    0.4659   -0.3296   -0.0876   -0.0329; ...
    0.0032    0.0766   -0.0656   -0.1294; ...
   -0.0672    0.4016    0.3017   -0.4844; ...
    1.0468   -0.3788   -2.4517    1.4656; ...
    1.5000   -0.6426    1.8564    0.5636];

e1 = tab_e(kbin_epsilon,1);
e2 = tab_e(kbin_epsilon,2);
e3 = tab_e(kbin_epsilon,3);
e4 = tab_e(kbin_epsilon,4);
e = nan(sz);
e(ok) = e1 + e2.*thetaS + Delta.*(e3+e4.*thetaS);
%%
a = reshape(a,sz);
b = reshape(b,sz);
c = reshape(c,sz);
d = reshape(d,sz);
e = reshape(e,sz);
