function [f1,f2,kbin] = calc_f1_f2(epsilon, Delta, thetaS)
% http://books.google.com/books?id=3YOKnEXJvzEC&pg=PA193&dq=clearness+index
% &ei=eUo_SpP2JZq8zgSe8uTHAw&hl=fr
% Solar radiation and daylight models
% Par Tariq Muneer, C. Gueymard, H. Kambezidis
% p 156

sz = size(epsilon);
ok = (~isnan(epsilon))&(~isnan(Delta))&(thetaS<pi/2);

bin_epsilon_0 = [1 1.065 1.230 1.5 1.95 2.8 4.5 6.2];
bin_epsilon_1 = [1.065 1.230 1.5 1.95 2.8 4.5 6.2 inf];
nbin = 8;


epsilon = epsilon(ok);
Delta = Delta(ok);
thetaS = thetaS(ok);
kbin_epsilon = ones(size(epsilon));

for kb = 1:nbin,
    b = (epsilon>=bin_epsilon_0(kb))&(epsilon<bin_epsilon_1(kb));
    kbin_epsilon(b) = kb;
end

tabF11 = [-0.0083 ; 0.1299 ; 0.3297 ; 0.5682 ; 0.8730 ; 1.1326 ; 1.0602 ; 0.6777];
tabF12 = [0.5877 ; 0.6826 ; 0.4869 ; 0.1875 ; -0.3920 ; -1.2367 ; -1.5999 ; -0.3273];
tabF13 = [-0.0621 ; -0.1514 ; -0.2211 ; -0.2951 ; -0.3616 ; -0.4118 ; -0.3589 ; -0.2504];

tabF21 = [-0.060 ; -0.019 ; 0.055 ; 0.109 ; 0.226 ; 0.288 ; 0.264 ; 0.156];
tabF22 = [0.072 ; 0.066 ; -0.064 ; -0.152 ; -0.462 ; -0.823 ; -1.127 ; -1.377];
tabF23 = [-0.022 ; -0.029 ; -0.026 ; -0.014 ; 0.001 ; 0.056 ; 0.131 ; 0.251];

% method_interp = 'nearest';

% f11 = interp1(1:8,tabF11,kbin_epsilon,method_interp,nan);
% f12 = interp1(1:8,tabF12,kbin_epsilon,method_interp,nan);
% f13 = interp1(1:8,tabF13,kbin_epsilon,method_interp,nan);
f11 = tabF11(kbin_epsilon);
f12 = tabF12(kbin_epsilon);
f13 = tabF13(kbin_epsilon);
f1 = nan(sz);
% f1(ok) = min(max(0, f11 + f12.*Delta + f13.*thetaS),1);
f1(ok) = f11 + f12.*Delta + f13.*thetaS;

if (nargout >= 2)
    %     f21 = interp1(1:8,tabF21,kbin_epsilon,method_interp,nan);
    %     f22 = interp1(1:8,tabF22,kbin_epsilon,method_interp,nan);
    %     f23 = interp1(1:8,tabF23,kbin_epsilon,method_interp,nan);
    f21 = tabF21(kbin_epsilon);
    f22 = tabF22(kbin_epsilon);
    f23 = tabF23(kbin_epsilon);
    f2 = nan(sz);
    %     f2(ok) = min(max(0, f21 + f22.*Delta + f23.*thetaS),1);
    f2(ok) = f21 + f22.*Delta + f23.*thetaS;
end

if (nargout >= 3)
    kbin = nan(sz);
    kbin(ok) = kbin_epsilon;
end    

