function SG = calc_sg_tst(geopoint, ymd, tst, vtl0, mod)
% geopoint : [lat lon elev]
% ymd : [Nx3] ymd table for N days
% tu : table of TST times for 1 day
% vtl0 : Linke turbidity
%  - empty [] => no cls computed
%  - scalar > 0 same TL for every day 
%  - scalar = -1 => use of get_TL5 at the given location
%  - 12x1 or 1x12  +> use of daily value of TL from linear interp of the monthly TL.
% TZ : time zone (optional)
% mod : 1 for modified ESRA (default), 0 for plain ESRA, like Helioclim 3

if (nargin < 4)
    vtl0 = [];
end

nbj = size(ymd,1);
jd = ymd_to_jd(ymd);
gp = geopoint;
nt = length(tst);
dt = tst(2)-tst(1);

TU = zeros(nt, nbj);
Tst = zeros(nt, nbj);

AlphaS = zeros(nt, nbj);
GammaS = zeros(nt, nbj);
CosThetaS = zeros(nt, nbj);


if (nargin < 5)
    mod = 1;
end

calc_cls = 1;
if (isempty(vtl0))
    calc_cls = 0;
else
    if (length(vtl0) == 1)
        if (vtl0 == -1)
            vtl0 = get_TL5(gp(1),gp(2),[1:12]);
        else
            vtl0 = repmat(vtl0,[1 12]);
        end
    end
    vtl0 = vtl0(:)';
    vtl = [vtl0(end) vtl0 vtl0(1)];
    vmm = [0:13];
    interp_tl = inline('interp1(vmm+0.5, vtl, d(:,2) + (d(:,3)-1)./nbday(d(:,1),d(:,2)), ''lin'', nan)', 'vmm', 'vtl', 'd');
end

GHItoa = zeros(nt, nbj);
if (calc_cls)
    BHIcls = zeros(nt, nbj);
    DHIcls = zeros(nt, nbj);
    GHIcls = zeros(nt, nbj);
end

Ecorr = zeros(nbj,1);
omega_ss = zeros(nbj,1);

delta = zeros(nbj,1);

for kj = 1:nbj,

    sd = solar_day(gp(1),gp(2),ymd(kj,3),ymd(kj,2),ymd(kj,1));
    delta(kj) = sd.declination;

    [omega, alphas, gammas, cos_thetaS] = solar_angles(gp(1),gp(2),ymd(kj,3),ymd(kj,2),ymd(kj,1), max(0,tst-dt/2), 0, 0);
    TU(:,kj) = tst + sd.dt_tst2tu;
    Tst(:,kj) = tst;

    GammaS(:,kj) = gammas(:);
    alphas = convertAz(alphas, 'e2i',gp(1));
    alphas = toRange(alphas,1);
    AlphaS(:,kj) = alphas(:);
    CosThetaS(:,kj) = cos_thetaS(:);
    
    if (calc_cls)
        tl_kj = interp_tl(vmm, vtl, ymd(kj,:));
        [Gcls_kj, Bcls_kj, Dcls_kj] = calc_CLSdt(gp(1),gp(2),ymd(kj,3),ymd(kj,2),ymd(kj,1), gp(3), ...
            tl_kj, tst, mod);
        GHIcls(:,kj) = Gcls_kj(:);
        BHIcls(:,kj) = Bcls_kj(:);
        DHIcls(:,kj) = Dcls_kj(:);
    end
    G0_kj = calc_H0dt(gp(1),gp(2),ymd(kj,3),ymd(kj,2),ymd(kj,1), tst);
    GHItoa(:,kj) = G0_kj(:);

    Ecorr(kj) = sd.eccentricity;
    omega_ss(kj) = sd.omega_s(2);

end

GammaS0 = GammaS;

Omega_ss = repmat(omega_ss(:)',[nt 1]);

[r0d,r0d_u0d] = calc_r0d(Tst(:),Omega_ss(:));
R0d = reshape(r0d,size(Tst));
R0d = R0d./repmat(sum(R0d,1),[nt 1]);
R0d_u0d = reshape(r0d_u0d,size(Tst));
R0d_u0d = R0d_u0d./repmat(sum(R0d_u0d,1),[nt 1]);

I0=1367.0;
SG.name = 'Solar Geometry';
SG.comment = '';
SG.geopoint = geopoint;
SG.ymd_begin = ymd(1,1:3);
SG.ymd_end = ymd(end,1:3);
SG.nbday = nbj;
SG.ymd = ymd;
SG.y = ymd_to_y(ymd);
SG.jd = ymd_to_jd(ymd);
SG.t = tst;
SG.dt = dt;
SG.nt = nt;
SG.type_t = 'TST';
SG.nbD = 5;
SG.I0Ecorrdt = I0*Ecorr*SG.dt;
SG.omega_ss = omega_ss;
SG.delta = delta;
SG.nomD = [];
SG.GammaS0 = GammaS0;
SG.GammaS =GammaS;
SG.CosThetaS = CosThetaS;
SG.AlphaS = AlphaS;
SG.GHItoa = GHItoa;
SG.R0d = R0d;
SG.R0d_u0d = R0d_u0d;
SG.TU = TU;
if (calc_cls)
    SG.GHIcls = GHIcls;
    SG.BHIcls = BHIcls;
    SG.DHIcls =DHIcls;
    SG.nomD = {'GammaS0','GammaS','AlphaS','GHItoa','R0d','R0d_u0d','GHIcls','BHIcls','DHIcls'};
else
    SG.nomD = {'GammaS0','GammaS','AlphaS','GHItoa','R0d','R0d_u0d'};
end

SG.nbD = length(SG.nomD);
