function y = conv2fft(x, h, nfft, mode)

% Les tailles des diffrentes matrices
nx = size(x);
nh = size(h);
rh = floor(nh/2) + 1;

if (nargin < 3)
	mode_auto = 1;
else
	mode_auto = 0;
end

if (nargin < 4)
	mode = 's(ymetrique)';
	%mode = 'r(eplicate)';
	%mode = 'c(ircular)';
	%mode = 'z(ero)';
	%mode = '-';
end

switch (lower(mode(1)))
	case 's'
		fct_pad = 'SymmetricPad';
	case 'c'
		fct_pad = 'CircularPad';
	case 'r'
		fct_pad = 'ReplicatePad';
	case 'z'
		fct_pad = 'ZeroPad';
	otherwise 
		fct_pad = '';
end

pad = [0 0];
nx0 = nx;
if (length(fct_pad) > 0)
	pad = rh;
	x = feval(fct_pad, x, pad, 'both');
	nx = size(x);
end

if (mode_auto)
	
	
	
else

	if (nfft(1) < nh(1))
		nfft(1) = nh(1);
	end

	if (nfft(2) < nh(2))
		nfft(2) = nh(2);
	end

	nfft = nfft(:)';

end


% Rglage particulier de fftw
planner_initial = fftw('planner');
% fftw('planner','exhaustive');

% Overlap-add method

L = nfft - nh + 1;
NF = ceil(nx./L);
NFt = prod(NF);

Fh = fft2(h, nfft(1), nfft(2));
y = zeros(nx(1),nx(2));

affichage = 1;

% if (affichage)
% 	fprintf(1,'Convolution par FFT2-BLCK [%d,%d]*[%d,%d] => %dx%d (=%d) FFT2[%d,%d]\n', ...
% 		nx0(1),nx0(2),nh(1),nh(2),NF(1),NF(2),NFt,nfft(1),nfft(2));
% end


istart1 = 1;
cmp = [0 0];

while (istart1 <= nx(1))

	iend1 = min(istart1+L(1)-1,nx(1));

	yend1 = min(nx(1),istart1+nfft(1)-1);

	cmp(1) = cmp(1) + 1;

	istart2 = 1;
	cmp(2) = 0;

	while (istart2 <= nx(2))

		iend2 = min(istart2 + L(2) - 1, nx(2));

		yend2 = min(nx(2),istart2+nfft(2)-1);

		y_seg = ifft2(fft2(x(istart1:iend1,istart2:iend2), nfft(1), nfft(2)).*Fh);

		y(istart1:yend1,istart2:yend2) = y(istart1:yend1,istart2:yend2) + y_seg(1:yend1-istart1+1,1:yend2-istart2+1);

		istart2 = istart2 + L(2);
		cmp(2) = cmp(2) + 1;
	end

	istart1 = istart1 + L(1);

end

% if (affichage)
% 	fprintf(1,'\n');
% 	fprintf('cmp = %dx%d\n', cmp(1), cmp(2));
% 	fprintf(1,'\n');
% end

rh = floor(nh/2);
y = y(rh(1)+pad(1)+[1:nx0(1)],rh(2)+pad(2)+[1:nx0(2)]);

if ~(any(any(imag(x)))||any(any(imag(h))))
	y = real(y);
end

% Rglage initial de fftw
planner_initial = 'hybrid';
fftw('planner',planner_initial);

return;

%% ZeroPad
function b = ZeroPad(a, padSize, direction)

numDims = numel(padSize);

% Form index vectors to subsasgn input array into output array.
% Also compute the size of the output array.
idx   = cell(1,numDims);
sizeB = zeros(1,numDims);
for k = 1:numDims
	M = size(a,k);
	switch direction
		case 'pre'
			idx{k}   = (1:M) + padSize(k);
			sizeB(k) = M + padSize(k);

		case 'post'
			idx{k}   = 1:M;
			sizeB(k) = M + padSize(k);

		case 'both'
			idx{k}   = (1:M) + padSize(k);
			sizeB(k) = M + 2*padSize(k);
	end
end

% Initialize output array with the padding value.  Make sure the
% output array is the same type as the input.
b         = mkconstarray(class(a), 0, sizeB);
b(idx{:}) = a;

%% mkconstarray
function out = mkconstarray(class, value, size)
out = repmat(feval(class, value), size);

%% CircularPad
function b = CircularPad(a, padSize, direction)

numDims = numel(padSize);

% Form index vectors to subsasgn input array into output array.
% Also compute the size of the output array.
idx   = cell(1,numDims);
for k = 1:numDims
	M = size(a,k);
	dimNums = 1:M;
	p = padSize(k);

	switch direction
		case 'pre'
			idx{k}   = dimNums(mod(-p:M-1, M) + 1);

		case 'post'
			idx{k}   = dimNums(mod(0:M+p-1, M) + 1);

		case 'both'
			idx{k}   = dimNums(mod(-p:M+p-1, M) + 1);

	end
end
b = a(idx{:});


%% SymmetricPad
function b = SymmetricPad(a, padSize, direction)

numDims = numel(padSize);

% Form index vectors to subsasgn input array into output array.
% Also compute the size of the output array.
idx   = cell(1,numDims);
for k = 1:numDims
	M = size(a,k);
	dimNums = [1:M M:-1:1];
	p = padSize(k);

	switch direction
		case 'pre'
			idx{k}   = dimNums(mod(-p:M-1, 2*M) + 1);

		case 'post'
			idx{k}   = dimNums(mod(0:M+p-1, 2*M) + 1);

		case 'both'
			idx{k}   = dimNums(mod(-p:M+p-1, 2*M) + 1);
	end
end
b = a(idx{:});

%% ReplicatePad
function b = ReplicatePad(a, padSize, direction)

numDims = numel(padSize);

% Form index vectors to subsasgn input array into output array.
% Also compute the size of the output array.
idx   = cell(1,numDims);
for k = 1:numDims
	M = size(a,k);
	p = padSize(k);
	onesVector = ones(1,p);

	switch direction
		case 'pre'
			idx{k}   = [onesVector 1:M];

		case 'post'
			idx{k}   = [1:M M*onesVector];

		case 'both'
			idx{k}   = [onesVector 1:M M*onesVector];
	end
end
b = a(idx{:});
