% clear all
% close all
% 
Nmin = 1000000;

vN = [2:1024];
nN = length(vN);

vT_r = zeros(nN,1);
vT_i = zeros(nN,1);

fftw('planner', 'exhaustive');

for kN =1:nN,
	
	N = vN(kN);
	
	Nt = floor(Nmin/N)+1;
	if (Nt < 20)
		Nt = 20;
	end
		
	u_r = rand(N,1);
	u_i = rand(N,1) + i*rand(N,1);

	if (mod(kN,10) == 1)
		disp([kN Nt])
	end
	
	tic;
	for kt = 1:Nt,
		Fu = fft(u_r);
	end
	vT_r(kN) = toc/Nt;

	tic;
	for kt = 1:Nt,
		Fu = fft(u_i);
	end
	vT_i(kN) = toc/Nt;
			
end

fftw('planner', 'hybrid');

save temps_fft_1d_32_2048 vN vT_i vT_r

