clear all
close all

load temps_fft_1d_32_2048.mat


nN = 1000;

vT2d = zeros(nN,1);
vN1 = zeros(nN,1);
vN2 = zeros(nN,1);

for kN = 1:nN,

	N1 = floor((max(vN)-min(vN))*rand(1,1)+min(vN));
	N2 = floor((max(vN)-min(vN))*rand(1,1)+min(vN));

	vN1(kN) = N1;
	vN2(kN) = N2;


	Nt = 5;
	disp([kN nN Nt])
	
	u_r = rand(N1,N2);

	tic;
	for kt = 1:Nt,
		Fu = fft2(u_r);
	end

	vT2d(kN) = toc/Nt;
	
	
	Nmax = max([N1 N2]);
	Nmin = min([N1 N2]);
	
	eT2d(kN) = Nmin*vT_r(Nmax-vN(1)+1) + Nmax*vT_i(Nmin-vN(1)+1);
	eT2d_1(kN) = N1*vT_r(N2-vN(1)+1) + N2*vT_i(N1-vN(1)+1);
	eT2d_2(kN) = N2*vT_r(N1-vN(1)+1) + N1*vT_i(N2-vN(1)+1);

	plot([1:kN],vT2d(1:kN),'b.',[1:kN],eT2d(1:kN),'ro',[1:kN],eT2d_1(1:kN),'gp',[1:kN],eT2d_2(1:kN),'k+')
	drawnow
	
end

