function out = correction_tilt_topo(gp, Dz, Hz, valpha, vbeta, ...
    ymd, dt, ...
    GHI, DHI, GHItoa, GHIcls, ...
    dt_i, GHItoa_i, AlphaS_i, GammaS_i, ...
    dt_o, options)
% function out = correction_tilt_topo(gp, Dz, Hz, valpha, vbeta, ...
%    ymd, dt, ...
%    GHI, DHI, GHItoa, GHIcls, ...
%    dt_i, GHItoa_i, AlphaS_i, GammaS_i, ...
%    dt_o, options)

options_def = struct('method','arias','albedo',0.2,...
    'minGammaS',1/50, 'minCosThetaS',0.087, 'seuils',[]);

if ((nargin < 17)||isempty(options))
    options = options_def;
end
fn = fieldnames(options_def);
for k = 1:length(fn),
    if (~isfield(options,fn{k}))
        options.(fn{k}) = options_def.(fn{k});
    end
end
fn = fieldnames(options);
for k = 1:length(fn),
    if (~isfield(options_def,fn{k}))
        warning('correction_tilt_topo:optionsWarning','options has not-identified fields');
    end
end

if ((nargin < 16)||isempty(dt_o))
    dt_o = dt;
end

%% Prparation des agglomrations
tu_i = [dt_i:dt_i:24];
tu_o = [dt_o:dt_o:24];
Magglo_i = precalc_agglo_I(tu_i,tu_o);

if (round(dt_o/dt_i)~=dt_o/dt_i)||(round(dt/dt_i)~=dt/dt_i)
    error('correction_tilt_topo:paramError','sampling times not compatible');
end

%% Test Nan

GHI(GHItoa==0) = 0;
idx_ok = find(~any(isnan(GHI)));

out.ymd = ymd;
out.tu = tu_o;
out.options = options;
out.valpha = valpha;
out.vbeta = vbeta;
ntilt = length(valpha);

out.GTI = nan(length(out.tu),length(ymd),ntilt);
out.BTI = nan(length(out.tu),length(ymd),ntilt);
out.DTI = nan(length(out.tu),length(ymd),ntilt);
out.RTI = nan(length(out.tu),length(ymd),ntilt);
out.BNI = nan(length(out.tu),length(ymd));

GHI = GHI(:,idx_ok);
DHI = DHI(:,idx_ok);
GHItoa = GHItoa(:,idx_ok);

GHItoa_i = GHItoa_i(:,idx_ok);
AlphaS_i = AlphaS_i(:,idx_ok);
GammaS_i = GammaS_i(:,idx_ok);

%% Correction Dz

if (~isempty(Dz)&&(abs(Dz)>1))
    z = gp(3);
    GHIcls = GHIcls(:,idx_ok);
    BHI = max(0, GHI - DHI);
    GHI = correctGHI_DZ(GHI, GHIcls, GHItoa, z, z+Dz);
    BHI = min(GHI,correctGHI_DZ(BHI, GHIcls, GHItoa, z, z+Dz));
else
    BHI = max(0, GHI - DHI);
end

%% Interpolation  dt_i

[GHI_i] = interp_I(GHI, GHItoa, GHItoa_i, dt, dt_i, '*lin');
[BHI_i] = interp_I(BHI, GHItoa, GHItoa_i, dt, dt_i, '*lin');
BHI_i = min(GHI_i, BHI_i);
BHI_i = max(0, BHI_i);

DHI_i = GHI_i - BHI_i;

%% Calcul des Masquages d'horizon

Mask0p_i = (GammaS_i>options.minGammaS);

v_GammaS_i = GammaS_i(Mask0p_i);
v_AlphaS_i = AlphaS_i(Mask0p_i);

if (~isempty(Hz))
    v_MaskHz_i = (v_GammaS_i>interp1(Hz(:,1),Hz(:,2),v_AlphaS_i,'*lin',nan));
    s_Vd = precalc_Vd(Hz);
    Vd00 = calc_Vd(s_Vd,0,0);
else
    v_MaskHz_i = ones(size(v_GammaS_i));
    s_Vd = [];
    Vd00 = 1;
end
out.MaskHz_i = zeros(size(DHI_i));
out.MaskHz_i(Mask0p_i) = v_MaskHz_i;

%%
v_GammaS_i = GammaS_i(Mask0p_i);
v_cosThetaS_i = sin(v_GammaS_i);

v_Rbni_i = 1./max(options.minCosThetaS,v_cosThetaS_i);

v_BNI_i = BHI_i(Mask0p_i).*v_Rbni_i;
v_BHI_i = BHI_i(Mask0p_i);
v_DHI_i = DHI_i(Mask0p_i);

switch(options.method)
    case {'arias','perez'}
        v_BNItoa_i = GHItoa_i(Mask0p_i).*v_Rbni_i;
        v_AM_i = calc_airmass(v_GammaS_i,gp(3),1);
        v_Delta_i = v_AM_i.*v_DHI_i./v_BNItoa_i;
        
        maxEpsilon = 10;
        v_K = (v_DHI_i > 0);
        v_A = (1 + v_BNI_i(v_K)./v_DHI_i(v_K));
        v_B = 1.041.*(pi/2-v_GammaS_i(v_K)).^3;
        v_Epsilon_i = maxEpsilon*ones(size(v_GammaS_i));
        v_Epsilon_i(v_K) = (v_A + v_B)./(1 + v_B);
        [v_F1_i,v_F2_i] = ...
            calc_f1_f2(v_Epsilon_i, v_Delta_i, pi/2-v_GammaS_i);
        v_DHI_i_circ = v_F1_i.*v_DHI_i;
        v_DHI_i_iso = v_DHI_i - v_DHI_i_circ;
        
    case 'muneer'
        v_Kb_i = min(1,v_BHI_i./GHItoa_i(Mask0p_i));
        a0 = 0.00263;
        a1 = 0.71200;
        a2 = 0.68830;
        v_DHI_i_circ = v_Kb_i.*v_DHI_i;
        v_DHI_i_iso = v_DHI_i - v_DHI_i_circ;
        
    otherwise
        error('correction_tilt_topo:optionError','options.method not implemented');
end

v_BHI_i_hz = v_MaskHz_i.*v_BHI_i;
v_DHI_i_circ_hz = v_MaskHz_i.*v_DHI_i_circ;
v_RHI_i_hz = options.albedo*max(0,1-Vd00)*(v_BHI_i_hz + v_DHI_i_circ_hz + (1-Vd00)*v_DHI_i_iso);

v_BNI_i_hz = v_BNI_i.*v_MaskHz_i;

BNI_i_hz = zeros(size(GHI_i));
BNI_i_hz(Mask0p_i) = v_BNI_i_hz;

BTI_i_hz = zeros(size(GHI_i));
DTI_i_hz = zeros(size(GHI_i));
DTI_i_hz_iso = zeros(size(GHI_i));
DTI_i_hz_cs = zeros(size(GHI_i));
RTI_i_hz = zeros(size(GHI_i));
Fbeta_i = zeros(size(GHI_i));

for kt = 1:ntilt,
    
    alpha = valpha(kt);
    beta = vbeta(kt);
    
    tilt_scalaire = 1;
    
    if (isnan(alpha)&&isnan(beta))
        alpha = v_AlphaS_i;
        beta = pi/2-v_GammaS_i;
        tilt_scalaire = 0;
    elseif isnan(alpha)
        alpha = v_AlphaS_i;
        tilt_scalaire = 0;
    elseif isnan(beta)
        beta = atan(cos(v_AlphaS_i-alpha)./tan(v_GammaS_i)); % A confirmer
        tilt_scalaire = 0;
    end
    
    if (isempty(s_Vd))
        Vd = (1+cos(beta))/2;
    else
        Vd = calc_Vd(s_Vd,alpha,beta);
    end
    
    Ct = max(0,1-Vd);
    
    v_cosThetaI_i = (cos(beta).*v_cosThetaS_i + ...
        sin(beta).*cos(v_GammaS_i).*cos(v_AlphaS_i-alpha));
    v_MaskB_i = (v_cosThetaI_i > 0);
    
    %     K = zeros(size(GHI_i));
    %     K(Mask0p_i) = v_Kb_i;
    %
    %     keyboard
    
    v_Rbti_i = v_MaskB_i.*(v_cosThetaI_i./max(options.minCosThetaS,v_cosThetaS_i));
    BTI_i_hz(Mask0p_i) = v_MaskHz_i.*v_BHI_i.*v_Rbti_i;
    RTI_i_hz(Mask0p_i) = options.albedo*Ct.*(v_BHI_i_hz + v_DHI_i_circ_hz + ...
        Vd00.*v_DHI_i_iso + v_RHI_i_hz);
    RTI_i_hz(isnan(RTI_i_hz)) = 0;
    
    switch(options.method)
        
        case 'arias'
            
            DTI_i_hz(Mask0p_i) = max(0,v_MaskHz_i.*v_DHI_i_circ.*v_Rbti_i + ...
                Vd.*v_DHI_i_iso);
            
        case 'perez'
            
            v_a_b_i = v_MaskB_i.*(v_cosThetaI_i)./max(0.087,v_cosThetaS_i);
            DTI_i_hz(Mask0p_i) = max(0,v_MaskHz_i.*v_DHI_i_circ.*v_a_b_i + ...
                Vd.*v_DHI_i_iso + v_F2_i.*sin(beta));
                        
        case 'muneer'
            
            XN2 = sin(beta) - beta.*cos(beta) - pi*sin(beta/2).^2;
            XN1_shaded = (2 * 5.73 / pi / (3. + 2. * 5.73));
            XN1_overcast = (2 * 1.68 / pi / (3. + 2. * 1.68));
            
            v_XN1_i = a0 - a1*v_Kb_i - a2*v_Kb_i.^2;
            v_XN1_i(v_Kb_i<=0) = XN1_overcast;
            v_XN1_i((v_MaskHz_i==0)|(v_MaskB_i==0)) = XN1_shaded;
            
            v_Fbeta_i = max(0,Vd + XN2.*v_XN1_i);
            Fbeta_i(Mask0p_i) = v_XN1_i;
            
            v_Fi_i = v_MaskB_i.*(v_cosThetaI_i./v_cosThetaS_i);
            v_Mask0p1_i_bar = (v_GammaS_i < 1/10);
            
            if (tilt_scalaire == 0)
                v_Fi_i(v_Mask0p1_i_bar) = sin(beta(v_Mask0p1_i_bar)).* ...
                    v_MaskB_i(v_Mask0p1_i_bar).*cos(alpha(v_Mask0p1_i_bar)-v_AlphaS_i(v_Mask0p1_i_bar))./(0.1-0.008*v_GammaS_i(v_Mask0p1_i_bar));
            else
                v_Fi_i(v_Mask0p1_i_bar) = sin(beta).* ...
                    v_MaskB_i(v_Mask0p1_i_bar).*cos(alpha-v_AlphaS_i(v_Mask0p1_i_bar))./(0.1-0.008*v_GammaS_i(v_Mask0p1_i_bar));
            end
            v_Fi_i = max(0,v_Fi_i);
            
            DTI_i_hz(Mask0p_i) = max(0,v_Fbeta_i.*v_DHI_i_iso) + max(0,v_MaskHz_i.*v_Fi_i.*v_DHI_i_circ);
            DTI_i_hz_iso(Mask0p_i) = max(0,v_Fbeta_i.*v_DHI_i_iso);
            DTI_i_hz_cs(Mask0p_i) = max(0,v_MaskHz_i.*v_Fi_i.*v_DHI_i_circ);
            
        otherwise
            error('correction_tilt_topo:optionError','options.method not implemented');
            
    end
    
    out.BTI(:,idx_ok,kt) = Magglo_i*BTI_i_hz;
    out.DTI(:,idx_ok,kt) = Magglo_i*DTI_i_hz;
    out.DTI_cs(:,idx_ok,kt) = Magglo_i*DTI_i_hz_cs;
    out.DTI_iso(:,idx_ok,kt) = Magglo_i*DTI_i_hz_iso;
    out.RTI(:,idx_ok,kt) = Magglo_i*RTI_i_hz;
    out.Fbeta_i = Fbeta_i;
    
    if (~isempty(options.seuils))
        
        nseuils = length(options.seuils);
        nbj = size(out.BNI,1);
        
        out.hours_GTI = nan(nseuils, nbj, ntilt);
        out.hours_BTI = nan(nseuils, nbj, ntilt);
        out.hours_BNI = nan(nseuils, nbj);
        GTI_i_hz = BTI_i_hz + DTI_i_hz + RTI_i_hz;
        for ks = 1:nseuils,
            out.hours_BTI(ks,idx_ok,kt) = sum(BTI_i_hz > options.seuils(ks)*dt_i,1)*dt_i;
            out.hours_GTI(ks,idx_ok,kt) = sum(GTI_i_hz > options.seuils(ks)*dt_i,1)*dt_i;
        end
        
    end
    
end

out.GTI(:,idx_ok,:) = out.BTI(:,idx_ok,:) + out.DTI(:,idx_ok,:) + out.RTI(:,idx_ok,:);
out.BNI(:,idx_ok) = Magglo_i*BNI_i_hz;

if (~isempty(options.seuils))
    for ks = 1:nseuils,
        out.hours_BNI(ks,idx_ok) = sum(BNI_i_hz > options.seuils(ks)*dt_i,1)*dt_i;
    end
end

