function [DSPs1s2,f] = cross_dsp1d(s1,s2,dt,L,f_apod,ND,d,type_norm)

s1 = s1(:);
s2 = s2(:);
% s = s - mean(s(:));
N = length(s1);

if (nargin < 3)
	dt = 1;
end
Te = dt;

if ((nargin < 4) || (isempty(L)))
    L = N;
end

if ((nargin < 5) || (isempty(f_apod)))
    f_apod = 'blackman';
end

if ((nargin < 6) || (isempty(ND)))
    ND = L;
end

if ((nargin < 7) || (isempty(d)))
    switch(f_apod)
        case 'boxcar'
            decal = round(30*L/100);
        case 'hanning'
            decal = round(37*L/100);
        case 'hamming'
            decal = round(36*L/100);
        case 'blackman'
            decal = round(30*L/100);
        case 'blackman_h4t'
            decal = round(30*L/100);
    end    
else
    if (d > 0)
        decal = round(d .* L /100);
    else
        decal = L;
    end	
end


if (nargin < 8)
	type_norm = 'dsp';
end

% nombre de segments utiliss
Nseg = floor((N - L) ./ decal + 1);

% optimisation du dcalage pour ce nombre de segments fix
if (Nseg ~= 1)
    decal = floor((N - L)./(Nseg - 1));
end

residu = N - ((Nseg - 1) .* decal + L);

% calcul de la fenetre d'apodisation
if strcmp(f_apod,'boxcar')
   h = feval(f_apod,L);
else
   h = feval(f_apod,L,'periodic');
end

switch (type_norm)
	case 'dsp'
		P = sum(h.^2)/L;
	case 'amplitude'
		P = (sum(h)^2)*Te/L;  
end 

DSPs1s2 = zeros(ND,1);

f = linspace(-0.5,0.5-1/ND,ND)*(1/Te);

for kl = 1:Nseg,
	sseg1 = s1((kl-1)*decal + [1:L]);
	sseg2 = s2((kl-1)*decal + [1:L]);
    F1 = fft(sseg1.*h,ND);
    F2 = fft(sseg2.*h,ND);
	DSPsseg = fftshift(F1.*conj(F2))/(L*P*Te);	
	DSPs1s2 = DSPs1s2 + DSPsseg/Nseg;
end
