function [R_m, d_m, nbj_m] = day_to_month(R_j, d_j, seuil_rc)

if (nargin < 3)
    seuil_rc = 1.2;
end


km = 0;
y_km = -1;
m_km = -1;
d_km = -1;

nd = size(R_j,2);
nj = size(R_j,1);

nm = ceil(nj/28);
R_m = zeros(nm, nd);
d_m = zeros(nm, 2);
nbj_m = zeros(nm, 2);

for j = 1:nj,

    y = d_j(j,1);
    m = d_j(j,2);
    d = d_j(j,3);

    if (not(m_km == m))
        km = km + 1;
        y_km = y;
        m_km = m;
        d_km = d;

        %         fprintf('%4d :: mois %d - anne %d\n', km, m, y);

        nbj_m(km, 2) = nbday(y, m);
        d_m(km,:) = [y m];
    end

    v = R_j(j,:);
    if (isempty(find(isnan(v))))
        nbj_m(km, 1) = nbj_m(km, 1) + 1;
        R_m(km,:) = R_m(km,:) + v;
    end

end

nbj_m = nbj_m(1:km,:);
d_m = d_m(1:km,:);

R_mc = R_m(1:km,:);

% nbj_min = 25;
% R_mc(nbj_m(:,1)<nbj_min,:) = nan;

rc = nbj_m(:,2)./nbj_m(:,1);
rc(rc>seuil_rc) = nan;
R_m = R_mc.*repmat(rc,1,nd);


