function h = dcercle(R,x,y,varargin)

if (nargin == 3)
   style='k-';
end

n = 128;

cercle = circle(R,x,y,n);

gcf;
h = patch(cercle(1,:),cercle(2,:),varargin{:});

function c = circle(R,y0,x0,n)

c = zeros(2,n);
v = [0:n-1];

c(1,:) = y0+R*sin(2*pi*v/(n-1)+pi/2);
c(2,:) = x0+R*cos(2*pi*v/(n-1)+pi/2);
