function varargout = diff_image_export(varargin)
% DIFF_IMAGE_EXPORT M-file for diff_image_export.fig
%      DIFF_IMAGE_EXPORT, by itself, creates a new DIFF_IMAGE_EXPORT or raises the existing
%      singleton*.
%
%      H = DIFF_IMAGE_EXPORT returns the handle to a new DIFF_IMAGE_EXPORT or the handle to
%      the existing singleton*.
%
%      DIFF_IMAGE_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DIFF_IMAGE_EXPORT.M with the given input arguments.
%
%      DIFF_IMAGE_EXPORT('Property','Value',...) creates a new DIFF_IMAGE_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before diff_image_export_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to diff_image_export_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help diff_image_export

% Last Modified by GUIDE v2.5 03-Mar-2003 15:55:54

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @diff_image_export_OpeningFcn, ...
    'gui_OutputFcn',  @diff_image_export_OutputFcn, ...
    'gui_LayoutFcn',  @diff_image_export_LayoutFcn, ...
    'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before diff_image_export is made visible.
function diff_image_export_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to diff_image_export (see VARARGIN)

% Choose default command line output for diff_image_export

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes diff_image_export wait for user response (see UIRESUME)
% uiwait(handles.Main);

% Stockage des donnes de visualisation
V.A = varargin{1};
V.B = varargin{2};

if (length(varargin) > 2)
    V.R = varargin{3};
else
    V.R = [];
end

V.zoom = 1;
V.zone = [1 1 512 512];

% Evaluation des deux lut
I = [V.A V.B];
I = I(:);

minI = max(1,floor(min(I)));
maxI = min(256,floor(max(I)+1));

h = zeros(256,1);
h(minI:maxI) = linspace(0,1,maxI-minI+1);
V.map1 = [h h h];

[J,hc] = histeq(uint8(I+0.5),256);
% hc = cumsum(hist(I,256));
% hc = hc'/max(hc);
V.map2 = [hc' hc' hc'];
V.map = V.map1;
V.reponse = -1;

set(hObject,'UserData',V);

% Initialisation
set(handles.Main,'DoubleBuffer','on');
set(handles.zoom,'Value',1);
set(handles.egalisation,'Value',0);
set(handles.blink,'UserData',1);

Visu(handles);
VisuZ(handles);


uiwait(handles.Main);


% --- Outputs from this function are returned to the command line.
function varargout = diff_image_export_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
V = get(handles.Main,'UserData');
varargout{1} = V.reponse;

% The figure can be deleted now
delete(handles.Main);


% --- Executes on button press in ChoixA.
function choixA_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


V = get(handles.Main,'UserData');
V.reponse = 1;
set(handles.Main,'UserData',V);

% Update handles structure
guidata(hObject, handles);

% Use UIRESUME instead of delete because the OutputFcn needs
% to get the updated handles structure.
uiresume(handles.Main);

% --- Executes on button press in ChoixB.
function choixB_Callback(hObject, eventdata, handles)
% hObject    handle to ChoixB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


V = get(handles.Main,'UserData');
V.reponse = 0;
set(handles.Main,'UserData',V);

% Update handles structure
guidata(hObject, handles);

% Use UIRESUME instead of delete because the OutputFcn needs
% to get the updated handles structure.
uiresume(handles.Main);

% --- Executes on button press in radiobutton1.
function radiobutton1_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton1


% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on button press in blink.
function blink_Callback(hObject, eventdata, handles)
% hObject    handle to blink (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

V = get(handles.Main,'UserData');

blink = get(hObject,'UserData');
set(hObject,'UserData',~blink);

x = [V.zone(2):1:V.zone(2)+V.zone(4)-1];
y = [V.zone(1):1:V.zone(1)+V.zone(3)-1];

axes(handles.axesA);
if (blink)
    image(x,y,V.B(x,y)),axis image, colormap(V.map),title('B');
else
    image(x,y,V.A(x,y)),axis image, colormap(V.map),title('A');
end

% --- Executes on button press in egalisation.
function egalisation_Callback(hObject, eventdata, handles)
% hObject    handle to egalisation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of egalisation


V = get(handles.Main,'UserData');
if (get(hObject,'Value') == 1)
    V.map = V.map2;
else
    V.map = V.map1;
end

set(handles.Main,'UserData',V);
Visu(handles);


% --- Executes during object creation, after setting all properties.
function zoom_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zoom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in zoom.
function zoom_Callback(hObject, eventdata, handles)
% hObject    handle to zoom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns zoom contents as cell array
%        contents{get(hObject,'Value')} returns selected item from zoom

V = get(handles.Main,'UserData');
V.zoom = 2^(get(hObject,'Value')-1);
V.zone(1:2) = [1 1];
V.zone(3:4) = [512 512]/V.zoom;
set(handles.Main,'UserData',V);
VisuZ(handles);
Visu(handles);

% --- Executes on mouse press over axes background.
function axesZ_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axesZ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

V = get(handles.Main,'UserData');

if (V.zoom > 1)
    
    p = get(hObject,'CurrentPoint');
    q = p(1,1:2);
    qx = q(2);
    qy = q(1);
    
    qx = max(1,qx);
    qx = min(qx,512-V.zone(4));
    
    qy = max(1,qy);
    qy = min(qy,512-V.zone(3));
    
    V.zone(1) = floor(qy + 0.5);
    V.zone(2) = floor(qx + 0.5);
    
end

set(handles.Main,'UserData',V);
Visu(handles);
VisuZ(handles);

% --- Executes on mouse press over axes background.



% % --- Executes on mouse press over figure background.
% function Main_ButtonDownFcn(hObject, eventdata, handles)
% % hObject    handle to Main (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)


% Visualisation des images
function Visu(handles)

V = get(handles.Main,'UserData');

x = [V.zone(2):1:V.zone(2)+V.zone(4)-1];
y = [V.zone(1):1:V.zone(1)+V.zone(3)-1];

axes(handles.axesA);
image(x,y,V.A(x,y)),axis image, colormap(V.map),title('A');

if (get(handles.diff,'Value'))
    axes(handles.axesB);
    D = V.B(x,y)-V.A(x,y);
    if ~(get(handles.egalisation,'Value'))
        imagesc(x,y,D),colormap(gray(256)),axis image,title('B-A');
    else
        %         hc = cumsum(hist(D(:),256));
        %         hc = hc'/max(hc);
        %         map = [hc hc hc];
        Deq = histeq(uint8(255*(D-min(D(:)))/(max(D(:))-min(D(:))) + 0.5),256);
        image(x,y,Deq),colormap(gray(256)),axis image,title('B-A');
    end
else
    axes(handles.axesB);
    image(x,y,V.B(x,y)),axis image, colormap(V.map),title('B');
end


function VisuZ(handles)

V = get(handles.Main,'UserData');

axes(handles.axesZ);
% imagesc(1:4:512,1:4:512,V.A(1:4:512,1:4:end)),axis image
% hold on
x0 = V.zone(1);
x1 = V.zone(1) + V.zone(3)-1;
y0 = V.zone(2);
y1 = V.zone(2) + V.zone(4)-1;
plot([x0 x0 x1 x1 x0],[y0 y1 y1 y0 y0],'r'),axis ij,axis([1 512 1 512]);
% hold off
% 
set(handles.axesZ,'ButtonDownFcn','diff_image(''axesZ_ButtonDownFcn'',gcbo,[],guidata(gcbo))');


% --- Executes on button press in diff.
function diff_Callback(hObject, eventdata, handles)
% hObject    handle to diff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Visu(handles);

% --- Executes when user attempts to close Main.
function Main_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to Main (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isequal(get(handles.Main, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(handles.Main);
else
    % The GUI is no longer waiting, just close it
    delete(handles.Main);
end


% --- Executes on key press over Main with no controls selected.
function Main_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Main (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

key = get(hObject,'CurrentCharacter');
key = lower(key);

V = get(handles.Main,'UserData');

if (double(key) >= 49) & (double(key) <= 57)
    fp = fopen('zones.mat','r');
    if (fp ~= -1)
        fclose(fp);
        load zones
        nz = length(zones);
        kz = double(key)-48;
        if (kz <= nz)
            
            disp(['Chargement de la zone ' num2str(kz)])
            V.zone = zones{kz};
            V.zoom = 512/V.zone(3);
            z = nextpow2(V.zoom) + 1;
            set(handles.Main,'UserData',V);
            set(handles.zoom,'Value',z);

            Visu(handles);
            VisuZ(handles);
            
        end
    end
    return
end


switch(key)
    
    case 's'
        
        if (~isempty(V.R))
            % Affichage des statiques
            disp('Image A - Reference :: ')
            eqm(V.A,V.R,32);
            disp('Image B - Reference :: ')
            eqm(V.B,V.R,32);
        end
        
    case 'b'
        
        diff_image('blink_Callback',handles.blink, eventdata, handles);
        
    case 'a'
        
        z = get(handles.zoom,'Value');
        if (z > 1)
            z = mod(z-1,4);
            
            set(handles.zoom,'Value',z);
            diff_image('zoom_Callback',handles.zoom, eventdata, handles);
        end
        
    case 'z'
        
        z = get(handles.zoom,'Value');
        if (z < 4)
            z = mod(z,4) + 1;
            
            set(handles.zoom,'Value',z);
            diff_image('zoom_Callback',handles.zoom, eventdata, handles);
        end
        
    case 'x'
        
        % test l''existence
        fp = fopen('zones.mat','r');
        if (fp == -1)
            zones{1} = V.zone;
            disp(['Chargement de la zone dans : 1']);
                            
            save zones zones
        else
            fclose(fp);
            load zones
            nz = length(zones);
            if (nz >= 9)
                warning('Plus de 9 zones dfinies : impossible');
            else
                nz = nz + 1;
                disp(['Sauvegarde de la zone dans : ' num2str(nz)]);
                zones{nz} = V.zone;
                save zones zones
            end
            
        end
        
    case 'c'
        
        fp = fopen('zones.mat','r');
        if (fp ~= -1)
            fclose(fp);
            delete('zones.mat');
            disp('Effacement des zones');
        end
        
    otherwise
        
end


% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor',[.9 .9 .9]);
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider




% --- Creates and returns a handle to the GUI figure. 
function h1 = diff_image_export_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

h1 = figure(...
'PaperUnits',get(0,'defaultfigurePaperUnits'),...
'CloseRequestFcn','diff_image(''Main_CloseRequestFcn'',gcf,[],guidata(gcf))',...
'Color',[0.752941176470588 0.752941176470588 0.752941176470588],...
'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'KeyPressFcn','diff_image(''Main_KeyPressFcn'',gcbo,[],guidata(gcbo))',...
'MenuBar','none',...
'Name','diff_image',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'PaperSize',[20.98404194812 29.67743169791],...
'PaperType',get(0,'defaultfigurePaperType'),...
'Position',[270 210 1162 905],...
'Renderer',get(0,'defaultfigureRenderer'),...
'RendererMode','manual',...
'Resize','off',...
'HandleVisibility','callback',...
'Tag','Main',...
'UserData',zeros(1,0));

setappdata(h1, 'GUIDEOptions', struct(...
'active_h', 1.020033e+002, ...
'taginfo', struct(...
'figure', 2, ...
'axes', 7, ...
'pushbutton', 7, ...
'radiobutton', 3, ...
'slider', 3, ...
'togglebutton', 3, ...
'text', 2, ...
'listbox', 2, ...
'popupmenu', 2), ...
'override', 0, ...
'release', 13, ...
'resize', 'none', ...
'accessibility', 'callback', ...
'mfile', 1, ...
'callbacks', 1, ...
'singleton', 1, ...
'syscolorfig', 1, ...
'lastSavedFile', 'd:\1_users\c109558\Matlab\DesmetPh\diff_image.m'));


h2 = axes(...
'Parent',h1,...
'Units','pixels',...
'Box','on',...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[512 77 128 128],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'ButtonDownFcn','diff_image(''axesZ_ButtonDownFcn'',gcbo,[],guidata(gcbo))',...
'Tag','axesZ');


h3 = get(h2,'title');

set(h3,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.49609375 1.05078125 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h4 = get(h2,'xlabel');

set(h4,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.49609375 -0.18359375 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off');

h5 = get(h2,'ylabel');

set(h5,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.22265625 0.48828125 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h6 = get(h2,'zlabel');

set(h6,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-3.99609375 6.46484375 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h7 = axes(...
'Parent',h1,...
'Units','pixels',...
'Box','on',...
'CameraPosition',[256.5 256.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Layer','top',...
'Position',[50 343 512 512],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 512],...
'XLimMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 512],...
'YLimMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesA');


h8 = get(h7,'title');

set(h8,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[256.0009765625 518.4873046875 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h9 = get(h7,'xlabel');

set(h9,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[256.0009765625 -22.4541015625 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off');

h10 = get(h7,'ylabel');

set(h10,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-30.4384765625 255.0029296875 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h11 = get(h7,'zlabel');

set(h11,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-48.4033203125 561.4033203125 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h12 = axes(...
'Parent',h1,...
'Units','pixels',...
'Box','on',...
'CameraPosition',[256.5 256.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[600 343 512 512],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 512],...
'XLimMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YLim',[1 512],...
'YLimMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesB');


h13 = get(h12,'title');

set(h13,...
'Parent',h12,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[256.0009765625 518.4873046875 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h14 = get(h12,'xlabel');

set(h14,...
'Parent',h12,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[256.0009765625 -22.4541015625 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off');

h15 = get(h12,'ylabel');

set(h15,...
'Parent',h12,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-30.4384765625 255.0029296875 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off');

h16 = get(h12,'zlabel');

set(h16,...
'Parent',h12,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-597.3291015625 561.4033203125 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h17 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Callback','diff_image(''blink_Callback'',gcbo,[],guidata(gcbo))',...
'ListboxTop',0,...
'Position',[9.8 19.4615384615385 30.2 3.92307692307692],...
'String','Blink',...
'Tag','blink');


h18 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Callback','diff_image(''egalisation_Callback'',gcbo,[],guidata(gcbo))',...
'ListboxTop',0,...
'Position',[107.6 20.3846153846154 14.8 3],...
'String','Egalisation',...
'Style','togglebutton',...
'Tag','egalisation');


h19 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'BackgroundColor',[1 1 1],...
'Callback','diff_image(''zoom_Callback'',gcbo,[],guidata(gcbo))',...
'ListboxTop',0,...
'Position',[99.8 16.5384615384615 30.2 3],...
'String',{ 'Zoom x1' 'Zoom x2' 'Zoom x4' 'Zoom x8' },...
'Style','popupmenu',...
'Value',1,...
'CreateFcn','diff_image(''zoom_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','zoom');


h20 = uicontrol(...
'Parent',h1,...
'Units','characters',...
'Callback','diff_image(''diff_Callback'',gcbo,[],guidata(gcbo))',...
'ListboxTop',0,...
'Position',[192 19.4615384615385 30.2 3.92307692307692],...
'String','Diffrence',...
'Style','togglebutton',...
'Tag','diff');


h21 = uicontrol(...
'Parent',h1,...
'Callback','diff_image_export(''slider2_Callback'',gcbo,[],guidata(gcbo))',...
'ListboxTop',0,...
'Position',[300 4 551 36],...
'String','Essai',...
'Style','slider',...
'Value',[-3 -2],...
'CreateFcn','diff_image_export(''slider2_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','slider2');



hsingleton = h1;


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      DIFF_IMAGE_EXPORT, by itself, creates a new DIFF_IMAGE_EXPORT or raises the existing
%      singleton*.
%
%      H = DIFF_IMAGE_EXPORT returns the handle to a new DIFF_IMAGE_EXPORT or the handle to
%      the existing singleton*.
%
%      DIFF_IMAGE_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DIFF_IMAGE_EXPORT.M with the given input arguments.
%
%      DIFF_IMAGE_EXPORT('Property','Value',...) creates a new DIFF_IMAGE_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 4480 $ $Date: 2017-01-05 15:35:42 +0100 (Thu, 05 Jan 2017) $

gui_StateFields =  {'gui_Name'
                    'gui_Singleton'
                    'gui_OpeningFcn'
                    'gui_OutputFcn'
                    'gui_LayoutFcn'
                    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);        
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [getfield(gui_State, gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % DIFF_IMAGE_EXPORT
    % create the GUI
    gui_Create = 1;
elseif numargin > 3 & ischar(varargin{1}) & ishandle(varargin{2})
    % DIFF_IMAGE_EXPORT('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % DIFF_IMAGE_EXPORT(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.
    
    % Do feval on layout code in m-file if it exists
    if ~isempty(gui_State.gui_LayoutFcn)
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        end
    end
    
    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    
    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig 
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA
        guidata(gui_hFigure, guihandles(gui_hFigure));
    end
    
    % If user specified 'Visible','off' in p/v pairs, don't make the figure
    % visible.
    gui_MakeVisible = 1;
    for ind=1:2:length(varargin)
        if length(varargin) == ind
            break;
        end
        len1 = min(length('visible'),length(varargin{ind}));
        len2 = min(length('off'),length(varargin{ind+1}));
        if ischar(varargin{ind}) & ischar(varargin{ind+1}) & ...
                strncmpi(varargin{ind},'visible',len1) & len2 > 1
            if strncmpi(varargin{ind+1},'off',len2)
                gui_MakeVisible = 0;
            elseif strncmpi(varargin{ind+1},'on',len2)
                gui_MakeVisible = 1;
            end
        end
    end
    
    % Check for figure param value pairs
    for index=1:2:length(varargin)
        if length(varargin) == index
            break;
        end
        try, set(gui_hFigure, varargin{index}, varargin{index+1}), catch, break, end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end
    
    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});
    
    if ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
        
        % Make figure visible
        if gui_MakeVisible
            set(gui_hFigure, 'Visible', 'on')
            if gui_Options.singleton 
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end
    
    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end
    
    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end
    
    if ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end    

function gui_hFigure = local_openfig(name, singleton)
if nargin('openfig') == 3 
    gui_hFigure = openfig(name, singleton, 'auto');
else
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end

