function DSPI = dsp2d(I,L,f_apod,ND,d,correct_var)

moyI = mean(I(:));
varI = mean((I(:)-moyI).^2);
I = I - moyI;
N = size(I);

if (nargin <= 3)
    ND = L;
end

if (nargin == 1)
    L = [nl nc];
end

if (length(L) == 1)
    L = [L L];
end

if (length(ND) == 1)
    ND = [ND ND];
end

if (nargin <= 2)
    f_apod = 'blackman';
end

if (nargin <= 4)
    d = [];
end
    
if isempty(d)
    switch(f_apod)
        case 'boxcar'
            decal = round(30*L/100);
        case 'hanning'
            decal = round(37*L/100);
        case 'hamming'
            decal = round(36*L/100);
        case 'blackman'
            decal = round(30*L/100);
        case 'blackman_h4t'
            decal = round(30*L/100);
    end    
else 
    if (d > 0)
        decal = round(d .* L /100);
    else
        decal = L;
    end
end

if (nargin < 6)
	correct_var = 0;
end

% nombre de segments utiliss
Nseg = floor((N - L) ./ decal + 1);

% optimisation du dcalage pour ce nombre de segments fix
if (Nseg(1) ~= 1)
    decal(1) = floor((N(1) - L(1))./(Nseg(1) - 1));
end
if (Nseg(2) ~= 1)
    decal(2) = floor((N(2) - L(2))./(Nseg(2) - 1));
end

residu = N - ((Nseg - 1) .* decal + L);

% calcul de la fenetre d'apodisation
if strcmp(f_apod,'boxcar')
   hy = feval(f_apod,L(1));
   hx = feval(f_apod,L(2));
else
   hy = feval(f_apod,L(1),'periodic');
   hx = feval(f_apod,L(2),'periodic');
end

h = hy*hx';
P = sum(h(:).^2)/prod(L);

DSPI = zeros(ND(1),ND(2));
Te = [1 1];

for kl = 1:Nseg(1),
    for kc = 1:Nseg(2),
        
        Iseg = I((kl-1)*decal(1) + [1:L(1)],(kc-1)*decal(2) + [1:L(2)]);
        DSPIseg = fftshift(abs(fft2(Iseg.*h,ND(1),ND(2))).^2)/(prod(L)*P*prod(Te));

        DSPI = DSPI + DSPIseg/prod(Nseg);
        
    end
end

if (correct_var)
    
    DSPI(ND(1)/2+1,ND(2)/2+1) = 0;
    
    varDSPI = mean(DSPI(:));
        
    DSPI = DSPI*varI/varDSPI;
    
    DSPI(ND(1)/2+1,ND(2)/2+1) = moyI^2*prod(ND);

end
