function [h,vA,vB] = hist2(A,B,n)

if (nargin < 3)
    nA = 128;
    nB = 128;
else
    if (length(n)==1)
        n = [n n];
    end
    nA = n(1);
    nB = n(2);
end

K = ~isnan(A)&~isnan(B);
A = A(K(:)==1);
B = B(K(:)==1);

p = 0.01;

vA = linspace(percentile100(A(:),p),percentile100(A(:),100-p),nA);
vB = linspace(percentile100(B(:),p),percentile100(B(:),100-p),nB);

da = vA(2)-vA(1);
db = vB(2)-vB(1);

h = hist3([B(:) A(:)],'edges',{vB(:),vA(:)});
h = h / (sum(h(:)));

if (nargout == 0)
    imagesc(vA,vB,log10(h)), colorbar
    axis xy
    
    [MA,MB] = meshgrid(vA,vB);
    hold on
    plot(vA,mean(MB.*h,1)./mean(h,1),'k');
    hold off
    grid
    
end
