function [h,vx] = histn_p(M,p,varargin)

[np,nd] = size(M);
vx = cell(nd,1);
switch(length(varargin))
    case 1
        if (length(varargin{1})==1)
            for kd = 1:nd,
                vx{kd} = linspace(percentile100(M(:,kd),p),percentile100(M(:,kd),100-p),varargin{1});
            end
        else
            for kd = 1:nd,
                vx{kd} = varargin{1}(:);
            end
        end
    case nd
        for kd = 1:nd,
            if (length(varargin{kd})==1)
                vx{kd} = linspace(percentile100(M(:,kd),p),percentile100(M(:,kd),100-p),varargin{kd});
            else
                vx{kd} = varargin{kd};
            end
        end
    otherwise
        error('Problem');
end

x0dxnx = zeros(nd,3);
for kd = 1:nd,
    x0dxnx(kd,1) = vx{kd}(1);
    x0dxnx(kd,2) = vx{kd}(2)-vx{kd}(1);
    x0dxnx(kd,3) = length(vx{kd});
    err_max = max(abs(vx{kd}-(x0dxnx(kd,1)+[0:x0dxnx(kd,3)-1]*x0dxnx(kd,2))));
    if (err_max > 1e-6)
        error('Problem');
    end
end

Mk = zeros(np,nd);
for kd = 1:nd,  
    Mk_kd = round((M(:,kd)-x0dxnx(kd,1))/x0dxnx(kd,2))+1;
    Mk_kd((Mk_kd<1)|(Mk_kd>x0dxnx(kd,3)))=nan;
    Mk(:,kd) = Mk_kd;
end
Mk(any(isnan(Mk),2),:) = [];
npv = size(Mk,1);

Ck = cell(nd,1);
for kd = 1:nd
    Ck{kd} = Mk(:,kd);
end

sz = x0dxnx(:,3)';

h = zeros(sz);
vh = h(:);

ind = sub2ind(sz,Ck{:});

for kp = 1:npv,
   vh(ind(kp)) = vh(ind(kp)) + 1;
end

h = reshape(vh,sz);

if (nargout==0)&&(nd==2)
    
   imagesc(vx{1},vx{2},db(h')); 
   axis xy
   colorbar
end
