function histoIrrad(mG, mJ, xlbl)

if (nargin < 2)
    mJ = (mG>0);
end

if (nargin < 3)
    xlbl = '';
end

gcf;
clf;
% set(gcf,'Position',[80   10   900   425]);

mG = mG(:);
mJ = mJ(:);
ind = find(not(isnan(mG)));
mG = mG(ind);
mJ = mJ(ind);

vG = mG(mJ>0);

n = length(vG);
nb = max(min(128,ceil(n/5)),2);

minG = min(vG);
maxG = max(vG);

b = linspace(minG,maxG,nb);
db = b(2)-b(1);
[h,b] = hist(vG,b);
h = 100*h/(n*db);
hc = cumsum(h)*db;

maxH = max(h)*1.1;

[ax,h1,h2] = plotyy(b,h,b,hc);
% set(h1, 'Color',[1 1 1],'Marker','.');
delete(h1)
set(h2, 'Color','g');
set(ax(2),'ytick',[0:10:100],'xgrid','on','ygrid','on');
axis(ax(1),[minG maxG 0 maxH]);
axis(ax(2),[minG maxG 0 100]);
hold on
bar(b,h,'b','Barwidth',1);
% grid
xlabel(xlbl);
ylabel('%');
