function vH = ifto_diff(vf, D, Dobt, H, vlambda, vSlambda)

[nl,nc] = size(vf);
vf = vf(:);
nf = length(vf);
vlambda = vlambda(:)';
nlambda = length(vlambda);

if (nargin < 6)
    vSlambda = ones(size(vlambda))/nlambda;
end

vH = zeros(nf,1);
if (isempty(Dobt))
    for kl = 1:nlambda,
        vH = vH + vSlambda(kl)*fto_diff(vf,D/(vlambda(kl)*H));
    end
else
    for kl = 1:nlambda,
        vH = vH + vSlambda(kl)*fto_diff(vf,D/(vlambda(kl)*H),Dobt/(vlambda(kl)*H));
    end    
end

vH = reshape(vH,nl,nc);