function info = infolum(fic_lum, machineformat);
% readlum : Ecriture au format LUM
% I = readlum(fic_lum)

% Latry : 0561273816

if (nargin < 2)
    machineformat = 'n';
end

[pstr,nom,ext,versn] = fileparts(fic_lum);
if (strcmp(ext,'.lum')==0)
	fic_lum = [fic_lum '.lum'];
end

fp = fopen(fic_lum,'rb');
if (fp == -1)
    msg = sprintf('Fichier lum : <%s> introuvable',fic_lum);
    error(msg);
end
fseek(fp,0,'eof');
sz = ftell(fp);
fseek(fp,0,'bof');

% Lecture du type

nb_col = fread(fp,1,'int',machineformat);
nb_lig = fread(fp,1,'int',machineformat);
type_ima = char(fread(fp,4,'uchar',machineformat)');
switch(type_ima)
    case '08BI'
        codage = 1;
        prec = 'uchar';
    case '16BI'
        codage = 2;
        prec = 'uint16';
    case '12BI'
        codage = 2;
        prec = 'uint16';
    case 'FLOA'
        codage = 4;
        prec = 'float';
    case 'DOUB'
        codage = 8;
        prec = 'double';
	otherwise
        error(['Type de codage ' type_ima ' non prvu']);
end
sz_hdr = nb_col*codage;
sz_data = sz-sz_hdr;
nb_plan = 1;
if (sz_data ~= nb_col*nb_lig*codage)
    nb_plan = fread(fp,1,'int',machineformat);
end
if (sz_data ~= nb_plan*nb_col*nb_lig*codage)
    error('Problme de cohrence du fichier lum');
end

if (nargout == 0)
    fprintf(1,'%s : %d plan(s) %dx%d de type %s\n', fic_lum, nb_plan, nb_lig,nb_col,type_ima);
else
    info.nbplan = nb_plan;
    info.nblig = nb_lig;
    info.nbcol = nb_col;    
    info.typeima = type_ima;
    info.szhdr = nb_col*codage;
end

fclose(fp);
