function iI = invI(I,C,v)
%invI(I,C,v) computes the invert matrix 1./I.
%
%   For elements of I equal to 0 or such that C is false, the invert will be v.
%
%   By default, C is true.
%   By default, v is nan.

if (nargin < 2)
    C = [];
end
if (nargin < 3)
    v = nan;
end
if (~isempty(C))
    C = C&(abs(I)>eps);
else
    C = (abs(I)>eps);
end

iI = repmat(v,size(I));
iI(C) = 1./I(C);



