function sip = ip(c,Hsat,lambda,pas)

[np,nc] = size(c);
[bx,by] = calc_box(c);
c(:,1) = c(:,1) - mean(bx);
c(:,2) = c(:,2) - mean(by);

sip.npup = np;

sip.diametre_pupille = [min(c(:,3))*2 max(c(:,3))*2];
dist = nan*ones(np,np);
d = nan*ones(np,np);

for k1 = 1:np,
	for k2 = 1:np,
		d(k1,k2) = norm(c(k1,1:2)-c(k2,1:2)) + c(k1,3) + c(k2,3);
		dist(k1,k2) = norm(c(k1,1:2)-c(k2,1:2)) - c(k1,3) - c(k2,3);
	end
end

sip.diametres_pup = 2*[min(c(:,3)) max(c(:,3))];

vdist = dist(:);
vdist = vdist(vdist>0);
if (~isempty(vdist))
    sip.distance_interpup = [min(vdist) max(vdist)];
else
    sip.distance_interpup = [0 0];
end

%% Calcul surfacique
if (nc == 3)
	surf(1) = sum(c(:,3).^2)*pi;
	surf(2) = surf(1);
else
	surf(1) = sum(c(:,3).^2)*pi;
	surf(2) = sum(c(:,3).^2-c(:,4).^2)*pi;
end

sip.surface_totale = surf;
sip.obturation_surface = surf(2)./surf(1);
sip.obturation_diametre = sqrt(surf(2)./surf(1));

%% Calcul des distances d'autocorrlation

dmax = max(d(:));
[dmax_a, dmin_a, a] = calc_d(c);
sip.a = a;
sip.dmax_a = dmax_a;
sip.dmin_a = dmin_a;
sip.dmax = max(dmax_a);
sip.dmin = min(dmin_a);

sip.rapport_dmin_dmax = sip.dmin/sip.dmax;
sip.remplissage_monopupille = surf(1)/(pi*(sip.dmin^2)/4);
sip.dilution_monopupille = 1-sqrt(surf(1)/(pi*(sip.dmin^2)/4));


%% dilution propre

% [alpha,dilution] = alpha_AC(c);
dilution = nan
sip.dilution_propre = dilution;

%% Calcul des surfaces d'autocorrlation

surf_F = 0;
for kp1 = 1:np,
	for kp2 = 1:kp1-1,
		surf_F = surf_F + 2*pi*(c(kp1,3)+c(kp2,3))^2;
	end
end
Dmax = 2*max(c(:,3));
surf_F = surf_F + pi*Dmax^2;

sip.surface_AC_max = surf_F;
sip.surface_AC_dmin = pi*sip.dmin^2;
sip.efficacite_surface_AC_dmin_max = sip.surface_AC_dmin/sip.surface_AC_max;

%% Calcul autocorrelation
if (nargin == 1)

% Radial
N = 64;
rd = linspace(0,dmax,N);
ra = linspace(0,pi,N);
[Mrd,Mra] = meshgrid(rd,ra);

rAC = xpup_ftm_calc(c,Mrd.*cos(Mra),Mrd.*sin(Mra));

sip.rd = rd;
sip.moy_rAC = mean(rAC);
sip.min_rAC = min(rAC);
sip.max_rAC = max(rAC);

elseif (nargin > 1)
    
    % Information sur Nyquist-cible
    if (length(lambda)>1)
        n_vl = 8;
        vl = linspace(min(lambda),max(lambda),n_vl);
    else
        n_vl = 1;
        vl = lambda;
    end
    
    N = 128;
    Fc_max = dmax/(min(lambda)*Hsat);
    Fc_min = dmax/(max(lambda)*Hsat);
   
    Fe = 1/pas;
    
    f = linspace(-Fc_max,Fc_max-2*Fc_max/N,N);
    [Mfx,Mfy] = meshgrid(f);

    rf = linspace(0,Fc_max,N);
    af = linspace(0,pi,N);
    [Mrf,Maf] = meshgrid(rf,af);
    rMfx = Mrf.*cos(Maf);
    rMfy = Mrf.*sin(Maf);
    
    FTM = zeros(N,N);
    rFTM = zeros(N,N);
    
    sip.rFTM_1p = zeros(1,N);
    
    for k = 1:n_vl,
        FTM = FTM + xpup_ftm_calc(c,Mfx*vl(k)*Hsat,Mfy*vl(k)*Hsat)/n_vl;        
        rFTM = rFTM + xpup_ftm_calc(c,rMfx*vl(k)*Hsat,rMfy*vl(k)*Hsat)/n_vl;        
        sip.rFTM_1p = sip.rFTM_1p + xpup_ftm_calc([0 0 sip.dmin/2],rf*vl(k)*Hsat,0*rf)/n_vl;
    end
  
    sip.rfn = rf/Fe;    
    sip.min_rFTM = min(rFTM);
    sip.max_rFTM = max(rFTM);
    sip.moy_rFTM = mean(rFTM);
    fn = f/Fe;
    sip.fn = f/Fe;
    sip.FTM = FTM;
    
    
    NyquistCarre = (max(abs(Mfx),abs(Mfy))<=0.5*Fe);
    NyquistCercle = (sqrt((Mfx).^2 + (Mfy).^2)<=0.5*Fe);

    FTM_det = (sinc(f/Fe).')*sinc(f/Fe);
    
    H = (FTM.*FTM_det);
    
    H_nr = H.*NyquistCarre;
    H_r = H - H_nr;

    [fn2,fn2x,fn2y] = mkf(N/2,1);
    
    % Periodisation de H
    H_r_d = interp2(fn,fn,H_r,fn2x-1,fn2y,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x-1,fn2y-1,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x,fn2y-1,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x+1,fn2y-1,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x+1,fn2y,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x+1,fn2y+1,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x,fn2y+1,'lin',0);
    H_r_d = H_r_d + interp2(fn,fn,H_r,fn2x-1,fn2y+1,'lin',0);
    
    H_d = interp2(fn,fn,H,fn2x,fn2y,'lin',0);
    
    M = (H_r_d > H_d/10);
    sip.SAR = zeros(N/2);
    sip.SAR(M) = H_d(M)./H_r_d(M);
    sip.sar = sqrt(sum(H_d(:).^2))/sqrt(sum(H_r_d(:).^2));
    
    vNyquistCarre = NyquistCarre(:);
    vNyquistCercle = NyquistCercle(:);
    
    vFTM = FTM(:);
    
    sip.min_FTM_cerclenyquist = min(vFTM(vNyquistCercle==1));
    sip.min_FTM_carrenyquist = min(vFTM(vNyquistCarre==1));
    sip.max_FTM_horscarrenyquist = max(vFTM(vNyquistCarre==0));    
    
end

if (nargout == 0)

    f = figure('Position',[200 200 900 900]);
    
    figure(f)
    hold on
    subplot(2,2,1), vp(c)
    dcercle(sip.dmin/2,0,0,'r');

    figure(f)
    subplot(2,2,2)
    hold on
    vp(c,'s')
    dcercle(sip.dmin,0,0,'r');
    if (length(lambda) == 1)
        lambda(2) = lambda(1);
    end
    
    if (nargin > 1)
        dcarre(lambda(1)*Hsat/(2*pas),0,0,'r--','LineWidth',3);
        dcarre(mean(lambda)*Hsat/(2*pas),0,0,'r--','LineWidth',3);
        dcarre(lambda(2)*Hsat/(2*pas),0,0,'r--','LineWidth',3);
    end

    if (nargin > 1)
        figure(f)
        subplot(2,2,3)
        plot(sip.rfn,sip.min_rFTM,'k',sip.rfn,sip.max_rFTM,'k',sip.rfn,sip.moy_rFTM,'r--',...
            sip.rfn,sip.rFTM_1p,[0.5 0.5],[0 1],'r--'), axis([0 max(sip.rfn) 0 1]);
        grid on
    else
        figure(f)
        subplot(2,2,3)
        plot(sip.rd,sip.min_rAC,'k',sip.rd,sip.max_rAC,'k',sip.rd,sip.moy_rAC,'r--');
        grid on
    end
    
    figure(f)
    subplot(2,2,4)    
	
    Nl = 15;
    axis([0 1 1 Nl])
	axis off
    
    kl = 0;
    
    s = sprintf('Fonction pupillaire :');
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;
    
    s = sprintf('  - Nombre de pupilles : %d', sip.npup);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Diametre de pupilles : [%.2f m - %.2f m]', sip.diametre_pupille(1),sip.diametre_pupille(2));
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Surface totale : %.2f m^2 (obturation surfacique : %.2f %%)', ...
        sip.surface_totale(2),100-100*sip.obturation_surface);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Distance inter-pupille : [%.2f m - %.2f m]', ...
        sip.distance_interpup(1),sip.distance_interpup(2));
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;
    
    s = sprintf('Autocorrlation :');
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Distance max : %.2f m', sip.dmax);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Distance max sans trou : %.2f (%.2f %%)', sip.dmin, 100*sip.dmin/sip.dmax);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Dilution surfacique / monopupille : %.2f %%', sip.remplissage_monopupille*100);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    s = sprintf('  - Dilution propre : %.2f %%', sip.dilution_propre*100);
    text(0,Nl-kl,s,'interpreter','tex');
    kl = kl + 1;

    if (nargin > 1)

        s = sprintf('FTM diffraction parfaite :');
        text(0,Nl-kl,s,'interpreter','tex');
        kl = kl + 1;

        s = sprintf('  - minimum FTM dans le cercle de Nyquist : %.2f', sip.min_FTM_cerclenyquist);
        text(0,Nl-kl,s,'interpreter','tex');
        kl = kl + 1;

        s = sprintf('  - minimum FTM dans le carre de Nyquist : %.2f', sip.min_FTM_carrenyquist);
        text(0,Nl-kl,s,'interpreter','tex');
        kl = kl + 1;

        s = sprintf('  - maximum FTM hors du carre de Nyquist : %.2f', sip.max_FTM_horscarrenyquist);
        text(0,Nl-kl,s,'interpreter','tex');
        kl = kl + 1;
        
        s = sprintf('  - Rapport Signal / Aliasing : %.2f', sip.sar);
        text(0,Nl-kl,s,'interpreter','tex');
        kl = kl + 1;

    end
    
end

return

figure(1)
clf
[bx,by] = calc_box(c);
c(:,1) = c(:,1) - mean(bx);
c(:,2) = c(:,2) - mean(by);
vp(c)
hold on
dcercle(sip.dmin/2,0,0,'r');

figure(2)
clf
vp(c,'s');

plot(sip.dmin_a.*cos(sip.a),sip.dmin_a.*sin(sip.a),'r.-', ...
    sip.dmin.*cos(sip.a),sip.dmin.*sin(sip.a),'r--', 'linewidth',1);
plot(sip.dmax_a.*cos(sip.a),sip.dmax_a.*sin(sip.a),'b.-', ...
    sip.dmax.*cos(sip.a),sip.dmax.*sin(sip.a),'b--', 'linewidth',1);




