function irrad_compare(main_title, date_format, dates, title1, irrad1, varargin)
%irrad_compare Compares 2 to 8 irradiation time series.
%
%   irrad_compare(main_title, date_format, dates, title1, irrad1, title2, irrad2, plot_irrad, stat_irrad, mCond) 
%   plots irrad1 and irrad2 time series and computes statistics of irrad2 wrt irrad1.
%   date_format is the date format on the x axis, e.g. 'mmmyy'.
%   'dates' must be a vector of dates of the same size as the time series.
%
%   Set plot_irrad = 1 to draw the time series in the current figure.
%   Set plot_irrad = 2 to draw the time series in the current sub-figure.
%
%   If stat_irrad is true (default), it computes statistics of irrad2 wrt irrad1.
%
%   mCond parameter restricts the comparison to elements such that mCond is true (default).
%
%   irrad_compare(main_title, date_format, dates, title1, irrad1, title2, irrad2, title3, irrad3, plot_irrad, stat_irrad, mCond) 
%   does the same for 3 time series, and so on up to 8 time series.

nvarargin = length(varargin); % number of optional parameters
i=1; % index of current optional parameter

% Get optional time series. Init missing time series to empty arrays.
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title2 = varargin{i};
    irrad2 = varargin{i+1};
    i=i+2;
else
    title2 = '';
    irrad2 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title3 = varargin{i};
    irrad3 = varargin{i+1};
    i=i+2;
else
    title3 = '';
    irrad3 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title4 = varargin{i};
    irrad4 = varargin{i+1};
    i=i+2;
else
    title4 = '';
    irrad4 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title5 = varargin{i};
    irrad5 = varargin{i+1};
    i=i+2;
else
    title5 = '';
    irrad5 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title6 = varargin{i};
    irrad6 = varargin{i+1};
    i=i+2;
else
    title6 = '';
    irrad6 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title7 = varargin{i};
    irrad7 = varargin{i+1};
    i=i+2;
else
    title7 = '';
    irrad7 = [];
end
if (nvarargin >= i+1 & length(varargin{i+1}) > 1) 
    title8 = varargin{i};
    irrad8 = varargin{i+1};
    i=i+2;
else
    title8 = '';
    irrad8 = [];
end

% Get optional plot_irrad, stat_irrad and mCond parameters. Default is true.
if (nvarargin >= i)
    assert(length(varargin{i}) == 1, 'irrad_compare: too many time series');
    plot_irrad = varargin{i}; 
    i=i+1;
else
    plot_irrad = 1; 
end 
if (nvarargin >= i)
    assert(length(varargin{i}) == 1, 'irrad_compare: too many time series');
    stat_irrad = varargin{i}; 
    i=i+1;
else
    stat_irrad = true; 
end 
if (nvarargin >= i)
    mCond = varargin{i}; 
    i=i+1;
else
    mCond = true; 
end 
assert(nvarargin < i, 'irrad_plot: incorrect parameters');

% convert dates to datenums
datenums = datenum(dates);

% convert nD arrays to 1D
irrad1 = irrad1(:);
irrad2 = irrad2(:);
irrad3 = irrad3(:);
irrad4 = irrad4(:);
irrad5 = irrad5(:);
irrad6 = irrad6(:);
irrad7 = irrad7(:);
irrad8 = irrad8(:);

% move dates to center of intervals
if length(datenums >= 2)
    datenums = datenums - (datenums(2)-datenums(1))/2;
end

if (plot_irrad>0)
    % get current figure or create a new one
    f = gcf;
    
    % if plot_irrad == 1, draw the time series in the current figure
    if plot_irrad == 1
        if strcmp(get(f,'visible'),'on') % if figure is visible
            figure(f) % bring figure to front
        end
        set(f,'position',[200 200 900 500]) % set position and size
    end
    
    % turn off Latex text interpreter
    set(f, 'DefaultTextInterpreter', 'none')

    % Plot data. Add markers if short time series (not too many data) or if many time series (which may overlap).
    if ~isempty(irrad8) % if 8 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks', datenums,irrad4,'--co', datenums,irrad5,'--gd', datenums,irrad6,'-.mx', datenums,irrad7,'k+');
            hold on
            plot(datenums,irrad8,'-*','Color',[0.1 0.6 0.1]);
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k', datenums,irrad4,'-c', datenums,irrad5,'g', datenums,irrad6,'m', datenums,irrad7,'k');
            hold on
            plot(datenums,irrad8,'-','Color',[0.1 0.7 0.1]);
        end
        l = legend(title1, title2, title3, title4, title5, title6, title7, title8);
    elseif ~isempty(irrad7) % if 7 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks', datenums,irrad4,'--co', datenums,irrad5,'--gd', datenums,irrad6,'-.mx', datenums,irrad7,'k+');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k', datenums,irrad4,'-c', datenums,irrad5,'g', datenums,irrad6,'m', datenums,irrad7,'k');
        end
        l = legend(title1, title2, title3, title4, title5, title6, title7);
    elseif ~isempty(irrad6) % if 6 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks', datenums,irrad4,'--co', datenums,irrad5,'--gd', datenums,irrad6,'-.mx');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k', datenums,irrad4,'--c', datenums,irrad5,'g', datenums,irrad6,'m');
        end
        l = legend(title1, title2, title3, title4, title5, title6);
    elseif ~isempty(irrad5) % if 5 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks', datenums,irrad4,'--co', datenums,irrad5,'--gd');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k', datenums,irrad4,'--c', datenums,irrad5,'g');
        end
        l = legend(title1, title2, title3, title4, title5);
    elseif ~isempty(irrad4) % if 4 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks', datenums,irrad4,'--co');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k', datenums,irrad4,'--c');
        end
        l = legend(title1, title2, title3, title4);
    elseif ~isempty(irrad3) % if 3 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+', datenums,irrad3,'-.ks');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b', datenums,irrad3,'-.k');
        end
        l = legend(title1, title2, title3);
    elseif ~isempty(irrad2) % if 2 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx', datenums,irrad2,'-b+');
        else
            plot(datenums,irrad1,'-r', datenums,irrad2,'-b');
        end
        l = legend(title1, title2);
    else % if 1 time series to draw
        if (size(irrad1) < 100)
            plot(datenums,irrad1,'-rx');
        else
            plot(datenums,irrad1,'-r');
        end
        l = legend(title1);
    end

    % turn off Latex text interpreter in legend
    set(l, 'Interpreter', 'none')

    % set the date tick locations  
    datenum0 = round(datenums(1));   % first day
    datenum1 = round(datenums(end)); % last day
    if ~isempty(strfind(date_format, 'SS')) % if format prints minutes
        ticks = [datenum0:1/1440:datenum1]; % 1 tick per minute
    elseif ~isempty(strfind(date_format, 'HH')) % if format prints hours
        ticks = [datenum0:1/24:datenum1]; % 1 tick per hour
    else
        ticks = [datenum0:datenum1]; % 1 tick per day
    end
    set(gca, 'XTick', ticks);
    
    % set date format
    datetick('x',date_format,'keepticks','keeplimits');
    
    % customize the text that the data cursor displays
    dcm_obj = datacursormode(f);
    set(dcm_obj, 'UpdateFcn', @irrad_compare_datatib_cb)

    % set figure title
    title(main_title);
    
    % force figure drawing now to workaround issues when opening many figures quickly
    refreshdata(f)
end

if stat_irrad
    % compare time series wrt irrad1
    fprintf('%s: "%s" wrt "%s":\n', main_title, title2, title1);
    statd_irrad_v6(irrad2, irrad1, mCond);
    if ~isempty(irrad3)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title3, title1);
        statd_irrad_v6(irrad3, irrad1, mCond);
    end
    if ~isempty(irrad4)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title4, title1);
        statd_irrad_v6(irrad4, irrad1, mCond);
    end
    if ~isempty(irrad5)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title5, title1);
        statd_irrad_v6(irrad5, irrad1, mCond);
    end
    if ~isempty(irrad6)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title6, title1);
        statd_irrad_v6(irrad6, irrad1, mCond);
    end
    if ~isempty(irrad7)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title7, title1);
        statd_irrad_v6(irrad7, irrad1, mCond);
    end
    if ~isempty(irrad8)
        fprintf('%s: "%s" wrt "%s":\n', 'Ditto', title8, title1);
        statd_irrad_v6(irrad8, irrad1, mCond);
    end
end

