function output_txt = irrad_compare_datatib_cb(obj,event_obj)
% This function is the callback of the Data Cursor tool in the graphs created by irrad-compare. 
% It displays the position of the data cursor with an enhaced format.
% obj          Currently not used (empty)
% event_obj    Handle to event object
% output_txt   Data cursor text string (string or cell array of strings).
%
% See https://fr.mathworks.com/help/matlab/creating_plots/data-cursor-displaying-data-values-interactively.html

pos = get(event_obj,'Position');
output_txt = {['Date : ', datestr(pos(1),'yyyy-mm-dd HH:MM:SS')],...
              ['Value: ', num2str(pos(2),'%.7g')]};
