function [ is_valid ] = is_albedo_valid( albedo)
%is_albedo_valid checks it is a valid albedo value
%   Firstly check is a numeric value. 
%  It returns true if is a valid value, false otherwise.

func_name='is_albedo_valid';

is_valid=true;


if (isnumeric(albedo)==false)
    fprintf('%s : albedo[%s] should be a numeric value\n', func_name, albedo);
    is_valid=false;
    return;
end

if (albedo < 0 | albedo > 1)
    fprintf('%s : albedo[%.4f] should be in range [0; 1].\n', func_name, albedo);
    is_valid=false;
    return;
end
    
end

