function [ is_valid ] = is_azimut_valid( azimut)
%is_azimut_valid checks it is a valid azimut value
%   Firstly check is a numeric value. 
%  It returns true if is a valid azimutvalue, false otherwise.

func_name='is_azimut_valid';

is_valid=true;

if (isnumeric(azimut)==false)
    fprintf('%s : azimut[%s] should be a numeric value\n', func_name, azimut);
    is_valid=false;
    return;
end

if (azimut < 0) | (azimut> 360)
    fprintf('%s : azimut[%.4f] is out of range [0; 360].\n', func_name, azimut);
    is_valid=false;
    return;
end
    
end

