function [ is_valid ] = is_date_valid( p_day, p_month, p_year)
%is_date_valid checks it is a valid date value
%   Firstly p_day, p_month and p_year are integer and in valid ranges.
%  It returns true if is a valid date, false otherwise.

func_name='is_date_valid';

is_valid=true;


if (is_integer_valid(p_day)==false)
    fprintf('%s : p_day should be a numeric value\n', func_name);
    is_valid=false;
    return;
end
if (is_integer_valid(p_month)==false)
    fprintf('%s : p_month should be a numeric value\n', func_name);
    is_valid=false;
    return;
end
if (is_integer_valid(p_year)==false)
    fprintf('%s : p_year should be a numeric value\n', func_name);
    is_valid=false;
    return;
end

if (p_day <0 | p_day > 31)
    fprintf('%s : p_day[%d] is out of range [1; 31].\n', func_name, p_day);
    is_valid=false;
    return;
end

if (p_month <0 | p_month > 12)
    fprintf('%s : month[%d] is out of range [1; 12].\n', func_name, p_month);
    is_valid=false;
    return;
end

if (p_year < 2004)
    fprintf('%s : year[%d/%d] out of range. Available dates start from 02/2004 up to yesterday.\n', func_name, p_month, p_year);
    is_valid=false;
    return;
end

if (p_year == 2004)
    if (p_month < 2)
        fprintf('%s : [%d/%d] out of range. Available dates start from 02/2004 up to yesterday.\n', func_name, p_month, p_year);
        is_valid=false;
        return;
    end
end

today_date=datetime('today');
today_year=year(today_date);

% not in the futur
if (today_year < p_year)
    fprintf('%s : [%d/%d] out of range. Available dates start from 02/2004 up to yesterday.\n', func_name, p_month, p_year);
    is_valid=false;
    return;
end

% checks the date is lower than yesterday
 yesterday_date=datetime('yesterday');
 
 str_yesterday=sprintf('%d/%d/%d', day(yesterday_date), month(yesterday_date), year(yesterday_date));
 str_requested_date=sprintf('%d/%d/%d', p_day,p_month,p_year);
 
 if ((datenum({str_yesterday},'dd/mm/yyyy') - datenum({str_requested_date},'dd/mm/yyyy')) < 0)
    fprintf('%s : [%d/%d/%d] out of range. Available dates start from 02/2004 up to yesterday.\n', func_name, p_day, p_month, p_year);
    is_valid=false;
    return;
end
    



end

