function [ is_valid ] = is_hc3_version_valid( hc3_version)
%is_hc3_version_valid checks it is a valid hc3_version value
%   Firstly check is a numeric value.
%  It returns true if is a valid hc3_versionvalue, false otherwise.

func_name='is_hc3_version_valid';

is_valid=true;

if (isa(hc3_version,'char')== false)
    fprintf('%s : hc3_version should be a char.\n', func_name);
    is_valid=false;
    return;
end


hc3v_pattern='hc3v';

% check starting pattern
if (length(hc3_version) < (length(hc3v_pattern)+1))
    fprintf('%s : hc3_version[%s] at least have %d char.\n', func_name, hc3v_pattern, (length(hc3v_pattern) + 1));
    is_valid=false;
    return;
end

if  (strncmp(hc3_version, hc3v_pattern, length(hc3v_pattern)) ~= 1)
    fprintf('%s : hc3_version[%s] does not have ''%s'' as starting pattern.\n', func_name, hc3_version, hc3v_pattern);
    is_valid=false;
    return;
end

% get version
version=hc3_version(length(hc3v_pattern)+1:length(hc3_version));
[num_version, status] = str2num(version);

if (status ~=1 )
   fprintf('%s : hc3_version[%s] has a valid pattern ''%s'', but the version[%s] should be an integer.\n', func_name, hc3_version, hc3v_pattern, version);
    is_valid=false;
    return;
end

if (is_integer_valid(num_version) == false)
    fprintf('%s : hc3_version[%s] should have a numerical version\n', func_name, hc3_version);
    is_valid=false;
    return;
end

% LS 02/2018: removed hc3v2 and hc3v3
if (num_version < 4)
    fprintf('%s : hc3_version[%s] is a deprecated version[%d]\n', func_name, hc3_version, num_version);
    is_valid=false;
    return;
end

if (num_version > 5)
    fprintf('%s : hc3_version[%s] is not yet a supported version[%d]\n', func_name, hc3_version, num_version);
    is_valid=false;
    return;
end


end

