function [ is_valid ] = is_lat_hc3_valid( lat)
%is_lat_valid checks it is a valid latitude value
%   Firstly check is a numeric value. And then checks it is in range [-90;
%   90]
% It returns true if is a valid latitude value, false otherwise.

func_name='is_lat_hc3_valid';

is_valid=true;

if (is_lat_valid( lat) == false)
    fprintf('%s : lat is not valid\n', func_name);
    is_valid=false;
    return;
end

if (lat < -66 | lat > 66)
    fprintf('%s : lat[%.4f] is out of hc3 range [-66; 66];\n', func_name, lat);
    is_valid=false;
    return;
end
    
end

