function [ is_valid ] = is_lat_valid( lat)
%is_lat_valid checks it is a valid latitude value
%   Firstly check is a numeric value. And then checks it is in range [-90;
%   90]
% It returns true if is a valid latitude value, false otherwise.

func_name='is_lat_valid';

is_valid=true;


% Check img coordinates
if (isnumeric(lat)==false)
    fprintf('%s : lat should be a numeric value\n', func_name);
    is_valid=false;
    return;
end
if (lat < -90 | lat > 90)
    fprintf('%s : lat[%.4f] is out of range [-90; 90];\n', func_name, lat);
    is_valid=false;
    return;
end
    
end

