function [ is_valid ] = is_lon_hc3_valid( lon)
%is_lon_valid checks it is a valid longitude value
%   Firstly check is a numeric value. And then checks it is in range [-180;
%   180]
%  It returns true if is a valid longitude value, false otherwise.

func_name='is_lon_hc3_valid';

is_valid=true;


% Check img coordinates
if (is_lon_valid(lon)==false)
    fprintf('%s : lon is not valid\n', func_name);
    is_valid=false;
    return;
end
if (lon < -66 | lon > 66)
    fprintf('%s : lon[%.4f] is out of HC3 range [-66; 66];\n', func_name, lon);
    is_valid=false;
    return;
end
    
end

