function [ is_valid ] = is_pixel_coord_valid( x, x_max)
%is_pixel_coord_valid Check if x is a valid pixel coordonate.
%   It checks it a numeric value. And then it checks if it is a postive integer.
%   If the optionnal parameter x_max is defined, then x should be lower than x_max. 

func_name='is_pixel_coord_valid';

is_valid=true;

% default values
if (nargin < 2)
    x_max=0;
end

% Check img coordinates
if (is_integer_valid(x)==false)
    fprintf('%s : x[%d] not an integer\n', func_name, x);
    is_valid=false;
end

if (x_max > 0)
    if (x > x_max)
        fprintf('%s : x[%d] is out of range [0, %d]\n', func_name, x, x_max);
        is_valid=false;
    end
end

end

