function [ is_valid ] = is_tilt_valid_or_999( tilt, lat, azi)
%is_tilt_valid checks it is a valid tilt value
%   Firstly check is a numeric value.
%  It returns true if is a valid tiltvalue, false otherwise.

func_name='is_tilt_valid';

is_valid=true;


if (isnumeric(tilt)==false)
    fprintf('%s : tilt should be a numeric value\n', func_name);
    is_valid=false;
end

if tilt == -999
    % DNI
    return;
end

if (tilt < 0) | tilt> 90
    fprintf('%s : tilt[%.4f] sis out of range [0; 90].\n', func_name, tilt);
    is_valid=false;
    return;
end


if tilt >0
    if lat>0 % north
        if (azi>=0 & azi<=90) | (azi>=270)
            fprintf(2, 'Warning tilt[%1.2f], azi[%1.2f] and lat[%1.2f] the plane facing north\n',tilt, azi, lat);
            % it is valid but could be a mistake. So a warning is logged.
            return;
        end
    else % south
        if (azi>=90 & azi<=270)
            fprintf(2, 'Warning tilt[%1.2f], azi[%1.2f] and lat[%1.2f] the plane facing south\n',tilt, azi, lat);
            % it is valid but could be a mistake. So a warning is logged.
            return;
        end
    end
end

end

