function [ is_valid ] = is_time_step_valid( time_step)
%is_time_step_valid checks it is a valid time_step value
%   Firstly checks if time_step is one of : m, h, w, d.
%   If not, then it checks it a valid integer value (1; 60]
% It returns true if is a valid time_step value, false otherwise.

func_name='is_time_step_valid';

is_valid=true;


% 1.
if (time_step=='w' | time_step=='d' | time_step=='m' | time_step=='h')
    return;
end

% 2.
if (is_integer_valid(time_step) == false)
    fprintf('%s : time_step should be either a single char (possible values ''w'' (week) ''d'' (day) ''m'' (month) ''h'' (hour)) or an interger ([0; 60])\n', func_name);
    is_valid=false;
    return;
end

if (time_step < 0 | time_step>60)
    fprintf('%s : time_step[%d] is an integer out of range [0; 60]\n', func_name, time_step);
    is_valid=false;
    return;
end

end

