function [R_a, d_a, nbj_a] = j2a(R_j, d_j, seuil_rc)

if (nargin < 3)
    seuil_rc = 1.1;
end

y_ka = -1;
m_ka = -1;
d_ka = -1;

nd = size(R_j,2);
nj = size(R_j,1);

na = length(unique(d_j(:,1)));

R_a = zeros(na, nd);
d_a = zeros(na, 1);
nbj_a = zeros(na, 2);

ka = 0;

for j = 1:nj,

    y = d_j(j,1);
    m = d_j(j,2);
    d = d_j(j,3);

    idx_y = find(d_a == y);
    if (isempty(idx_y))
        ka = ka + 1;
        y_ka = y;
        m_ka = m;
        d_ka = d;                       
        nbj_a(ka, 2) = sum(nbday(y, [1:12]));
        d_a(ka) = y;
        idx_y = ka;
    end
    if (length(idx_y)>1)
        error('impossible');
    end
    v = R_j(j,:);
    if (isempty(find(isnan(v))))
        nbj_a(idx_y, 1) = nbj_a(idx_y, 1) + 1;        
        R_a(idx_y,:) = R_a(idx_y,:) + v;        
    end
    
end

nbj_a = nbj_a(1:ka,:);
d_a = d_a(1:ka,:);

R_ac = R_a(1:ka,:);

rc = nbj_a(:,2)./nbj_a(:,1);
rc(rc>seuil_rc) = nan;

R_a = R_ac.*repmat(rc,1,nd);

nbj_a(:,3) = rc;



