function [ col, row ] = latlon_to_wgs84_pixel(MAP_LAT_MAX, MAP_LON_MIN, MAP_LAT_RATIO, MAP_LON_RATIO, lat, lon)
% latlon_to_wgs84_pixel(MAP_LAT_MAX, MAP_LON_MIN, MAP_LAT_RATIO, MAP_LON_RATIO, lat, lon) 
% converts (lat, lon) in degrees to WGS84 pixel (1-based).
% (MAP_LAT_MAX, MAP_LON_MIN) defines the (top, left) corner of the grid frame, in degrees
% (MAP_LAT_RATIO, MAP_LON_RATIO) defines the lat x lon ratios wrt degrees, e.g. (120, 120)

assert(MAP_LAT_RATIO > 0);
assert(MAP_LON_RATIO > 0);

col = round( (lon - MAP_LON_MIN)*MAP_LON_RATIO + 0.5 );
row = round(-(lat - MAP_LAT_MAX)*MAP_LAT_RATIO + 0.5 );
