function [x,y] = loc_inv(lat, lon, h, lon_sat)
%
% This is the formula used by Helioclim 3. There is a 0.5 pixel shift compared to:
%   [1] LRIT/HRIT Global Specification, Issue 2.6, August 1999.
%

if (nargin < 3)
    h = 0;
end
if (nargin < 4)
    lon_sat = 0;
end

r_pol = 6356.5838e3;
r_eq = 6378.1690e3;
hsat = 42164e3;
Scanstep = 0.00025153;
nblig = 3712; 
nbcol = 3712; 
deltaX = Scanstep/3.0; 
deltaY = Scanstep/3.0; 
lambda_e = lon*pi/180;
lambda_sat = lon_sat*pi/180;

phi_e = atan((r_pol/r_eq)^2*tan(lat*pi/180));

re = r_pol./sqrt(1-(r_eq^2-r_pol^2)/r_pol^2*cos(phi_e).^2) + h;

r1 = hsat-re.*cos(phi_e).*cos(lambda_e-lambda_sat);
r2 = -re.*cos(phi_e).*sin(lambda_e-lambda_sat);
r3 = re.*sin(phi_e);

lambda_s = atan(r2./r1);
phi_s = asin(r3./sqrt(r1.^2+r2.^2+r3.^2));

x = nbcol-(lambda_s/deltaX+nbcol/2-0.5);
y = nblig-(phi_s/deltaY+nblig/2-0.5);


