function Im = nanmedfilt2(I,sz)
%nanmedfilt2 2D median filter ignoring NaNs
%   Im = nanmedfilt2(I, [m n]) performs median filtering of the matrix I in two dimensions. 
%   Each output pixel contains the median value in the m-by-n neighborhood 
%   around the corresponding pixel in the input image.

% if square neighborhood
if (length(sz)==1)
    sz = [sz sz];
end

% add symmetric padding
pad = sz;
Ipad = padarray(I,pad,'both','symmetric');

% filter image
Ipad_m = nan(size(Ipad));
for kl = sz(1)+1:size(Ipad,1)-sz(1)
    for kc = sz(2)+1:size(Ipad,2)-sz(2)
        wIpad = Ipad(kl+[-sz(1):sz(1)],kc+[-sz(2):sz(2)]); % neighbors
        Ipad_m(kl,kc) = nanmedian(wIpad(:)); % neighbors median
    end
end

% crop padding
Im = Ipad_m(pad(1)+[1:size(I,1)],pad(2)+[1:size(I,2)]);

