function Im = nanmedfilt2_if(I,sz,val)
%nanmedfilt2_if 2D median filter of pixels with value val, ignoring NaNs neighbor pixels.
%   Im = nanmedfilt2_if(I, [m n], val) performs median filtering of pixels with value val in the 
%   matrix I in two dimensions. 
%   Each computed pixel contains the median value in the m-by-n neighborhood 
%   around the corresponding pixel in the input image. NaNs neighbor pixels are ignored.

% if square neighborhood
if (length(sz)==1)
    sz = [sz sz];
end

% add symmetric padding
pad = sz;
Ipad = padarray(I,pad,'both','symmetric');

% filter Ipad pixels with value val into Ipad_m
if isnan(val)
    Ipad_m = Ipad;
    for kl = sz(1)+1:size(Ipad,1)-sz(1),
        for kc = sz(2)+1:size(Ipad,2)-sz(2),
            if isnan(Ipad_m(kl,kc))
                wIpad = Ipad(kl+[-sz(1):sz(1)],kc+[-sz(2):sz(2)]); % neighbors
                Ipad_m(kl,kc) = nanmedian(wIpad(:)); % neighbors median
            end
        end
    end
else
    Ipad_m = Ipad;
    Ipad(Ipad==val) = nan; % remove pixels with value val from the source
    for kl = sz(1)+1:size(Ipad,1)-sz(1),
        for kc = sz(2)+1:size(Ipad,2)-sz(2),
            if Ipad_m(kl,kc) == val
                wIpad = Ipad(kl+[-sz(1):sz(1)],kc+[-sz(2):sz(2)]); % neighbors
                Ipad_m(kl,kc) = nanmedian(wIpad(:)); % neighbors median
            end
        end
    end
end

% crop padding
Im = Ipad_m(pad(1)+[1:size(I,1)],pad(2)+[1:size(I,2)]);

