function xpc = percentile(x,pc)
% xpc = percentile(x,pc) computes the percentile pc of the vector x.
%   CAUTION: pc must be between 0 and 1.

x = x(~isnan(x));

if (nargin < 2)
    pc = 0;
end

x = x(:);
nx = length(x);
if (pc == 0)
    xpc = min(x);
    return
end
if (pc == 1)
    xpc = max(x);
    return
end

nb = nx/4;
[h,b] = hist(x,linspace(min(x),max(x),nb));
db = b(2)-b(1);
h = h/(db*nx);

hc = cumsum(h)*db;
npc = length(pc);

% Interpolation
npi = 1024;
bi = linspace(min(b),max(b),npi);
hci = interp1(b,hc,bi,'lin');
% plot(b,hc,'ro',bi,hci,'b')

for kpc = 1:npc,   
    xpc(kpc) = bi(min(find(hci>pc(kpc))));    
end

