function xpc = percentile100(x,pc,method)
% xpc = percentile100(x,pc,method) computes the percentile pc of the vector x.
%   CAUTION: pc must be between 0 and 100.
%
%   'method' specifies the interpolation method among 'linear' = linear interpolation (default) and 'nearest'= nearest neighbor interpolation.

if (nargin < 3)
    method = 'lin';
end

x = x(:);
if isnan(nanmax(x)) 
    xpc = NaN;
    return;
end
x(isnan(x)) = [];
x = sort(x);
n = length(x);

q = [0 100*(0.5:(n-0.5))./n 100]';
xx = [x(1); x(1:n); x(n)];

xpc = interp1(q,xx,pc(:),method);


