function I = readenvi(fic)

machineformat = 'n';
fic_hdr = [fic '.hdr'];

fp = fopen(fic_hdr,'rt');
if (fp == -1)
    error('Header %s introuvable', fic_hdr);
end

ligne = fgetl(fp);
if (strcmp(ligne,'ENVI')~=1)
    error('Header %s incompatible', fic_hdr);
end

ok = 0;
while (ok == 0)
    ligne = fgetl(fp);
    if (strncmp(ligne,'samples',7)==1)
        ok = 1;
    end
end
if (strncmp(ligne,'samples',7)~=1)
    error('Header %s incompatible [samples]', fic_hdr);
end
nc = sscanf(ligne,'samples = %d');

ligne = fgetl(fp);
if (strncmp(ligne,'lines',5)~=1)
    error('Header %s incompatible [lines]', fic_hdr);
end
nl = sscanf(ligne,'lines = %d');

ligne = fgetl(fp);
if (strncmp(ligne,'bands',5)~=1)
    error('Header %s incompatible [bands]', fic_hdr);
end
nb = sscanf(ligne,'bands = %d');

ligne = fgetl(fp);
if (strncmp(ligne,'header offset',13)~=1)
    error('Header %s incompatible [header offset]', fic_hdr);
end
header_offset = sscanf(ligne,'header offset = %d');

ligne = fgetl(fp);
ligne = fgetl(fp);
if (strncmp(ligne,'data type',9)~=1)
    error('Header %s incompatible [data type]', fic_hdr);
end
data_type = sscanf(ligne,'data type = %d');

ligne = fgetl(fp);
if (strncmp(ligne,'interleave',10)~=1)
    error('Header %s incompatible [interleave]', fic_hdr);
end
interleave = sscanf(ligne,'interleave = %s');

fclose(fp);

%%
fp = fopen(fic,'rb');
if (fp == -1)
    msg = sprintf('Fichier : <%s> introuvable',fic);
    error(msg);
end

% Lecture du type
fseek(fp,0,'eof');
sz = ftell(fp);
fseek(fp,0,'bof');

switch(data_type)
    case 1
        codage = 'uint8';
        tpix = 1;
    case 2
        codage = 'int16';
        tpix = 2;
    case 12
        codage = 'uint16';
        tpix = 2;
    case 4
        codage = 'float';
        tpix = 4;
    case 5
        codage = 'double';
        tpix = 8;
    otherwise
        error('Type ENVI %d non prvu', data_type);
end

sz_th = nc*nl*nb*tpix + header_offset;
if (sz ~= sz_th)
    warning('Taille incompatible du header');
end

fseek(fp,header_offset,'bof');
I = fread(fp,[nc,nl],codage,machineformat)';
