function I = readlum(fic_lum, machineformat,flip);
% readlum : Ecriture au format LUM
% I = readlum(fic_lum)
% Latry : 0561273816

if (nargin < 2)
    machineformat = 'n';
end
if (nargin < 3)
    flip = 0;
end

[pstr,nom,ext,versn] = fileparts(fic_lum);
if (strcmp(ext,'.lum')==0)
	fic_lum = [fic_lum '.lum'];
end

fp = fopen(fic_lum,'rb');
if (fp == -1)
    msg = sprintf('Fichier lum : <%s> introuvable',fic_lum);
    error(msg);
end

% Lecture du type
fseek(fp,0,'eof');
sz = ftell(fp);
fseek(fp,0,'bof');

nb_col = fread(fp,1,'int',machineformat);
nb_lig = fread(fp,1,'int',machineformat);
type_ima = char(fread(fp,4,'uchar',machineformat)');
switch(type_ima)
    case '08BI'
        codage = 1;
        prec = 'uchar';
    case '16BI'
        codage = 2;
        prec = 'uint16';
    case '12BI'
        codage = 2;
        prec = 'uint16';
    case 'FLOA'
        codage = 4;
        prec = 'float';
    case 'DOUB'
        codage = 8;
        prec = 'double';
	otherwise
        error(['Type de codage ' type_ima ' non prvu']);
end
sz_hdr = nb_col*codage;
sz_data = sz-sz_hdr;
nb_plan = sz_data/codage/nb_col/nb_lig


fseek(fp,sz_hdr,'bof');
I = zeros(nb_lig, nb_col, nb_plan);
for k = 1:nb_plan
    I_k = fread(fp,fliplr([nb_lig nb_col]),prec,machineformat);
    I(:,:,k) = I_k';
end
fclose(fp);


