function Ir = rotima(I,A,dg)

if (nargin < 3)
    dg = 7;
end

cA = cos(A);
sA = sin(A);

[nl,nc] = size(I);

x0 = nc/2;
y0 = nl/2;

tx = x0*(1-cA)-y0*sA;
ty = y0*(1-cA)+x0*sA;

T = [cA sA tx ; -sA cA ty];

Ir = bspline_affine(I,T,[nl,nc],dg);



