function scatter2(x,y,same,lbl,nobias)

if (nargin < 3)
    same = 1;
end

if (nargin < 4)
    lbl = [];
end

if (nargin < 5)
    nobias = 0;
end


x = x(:);
y = y(:);

ind = find(~isnan(x)&~isnan(y));
x = x(ind);
y = y(ind);

n = length(x);

b = mean(x-y);
et = std(x-y,0);
eqm = sqrt(mean((x-y).^2));

nb = max(min(64,ceil(n/5)),2);

if (nobias == 0) 
    [c,cint,r,rint,stats] = regress(y,[x ones(n,1)]);
else
    [c,cint,r,rint,stats] = regress(y,x);
    c(2) = 0;
    cint(2,:) = [0 0];
end
r = -r;

clf

set(gcf,'Position',[80   20   900   700])

pc = 1/100;

if (same)
    mind = percentile([x(:); y(:)],pc);
    maxd = percentile([x(:); y(:)],1-pc);
    minx = mind;
    miny = mind;
    maxx = maxd;
    maxy = maxd;
    hold on
    xd = linspace(mind,maxd,2);
    hd = plot(xd,xd,'k:','linewidth',0.5);
    hold off
%     axis equal
else
    minx = min(x);
    maxx = max(x);
    miny = min(y);
    maxy = max(y);
end
axis([minx maxx miny maxy])
% set(gca,'Xticklabel',[]);
% set(gca,'Yticklabel',[]);

bx = linspace(minx,maxx,nb);
dbx = bx(2)-bx(1);
[hx] = histc(x,bx);
hx = hx/(n*dbx);
by = linspace(miny,maxy,nb);
dby = by(2)-by(1);
[hy] = histc(y,by);
hy = hy/(n*dby);
hxy = hist3([y(:) x(:)],'edges',{bx(:),by(:)});

maxhx = max(hx*dbx);
maxhy = max(hy*dby);
if (same)
    maxhx = max([maxhx maxhy]);
    maxhy = maxhx;
end


hc = subplot('position',[0.4 0.4 0.55 0.55]);
% imagesc(bx,by,hxy*dbx*dby,[0 max(hxy(:))*dbx*dby]);
map = colormap(jet);
map(1,:) = [1 1 1];
colormap(map);
axis xy
hold on
% h = plot(x,c(1)*x+c(2),'g');
h = plot(x,c(1)*x+c(2),'g',x,y,'r.', 'linewidth', 0.01);

if (same)
    xt = get(gca,'XTick');
    set(gca,'YTick', xt);
    plot(xt,xt,'k--');
end
grid
if (nobias)
    legend(h(1),sprintf('Y = %.2fX', c(1)),'location','NorthWest');
else
    if (c(2) > 0)
        legend(h(1),sprintf('Y = %.2fX + %.2f', c(1), c(2)),'location','NorthWest');
    else
        legend(h(1),sprintf('Y = %.2fX - %.2f', c(1), abs(c(2))),'location','NorthWest');
    end
end
if (not(isempty(lbl)))
    text((maxx+minx)/2,miny+(maxy-miny)/30,['X :: ' lbl{1}],'HorizontalAlignment','center','BackgroundColor',[.7 .9 .7]);
    text(minx+(maxx-minx)/30,(miny+maxy)/2,['Y :: ' lbl{2}],'HorizontalAlignment','center','Rotation',90,'BackgroundColor',[.7 .9 .7]);
end


h2 = subplot('position',[0.4 0.05 0.55 0.30]);
hl2 = bar(bx,hx*dbx,'hist');
text(maxx,maxhx,sprintf('mean = %.2f, std = %.2f [%d valeurs]', mean(x), std(x), n),...
    'HorizontalAlignment','right','VerticalAlignment','top','BackgroundColor',[.7 .9 .7]);
axis([minx maxx 0 maxhx])
grid

h1 = subplot('position',[0.05 0.4 0.30 0.55]);
hl1 = barh(by,hy*dby,'hist');
text(maxhy,maxy,sprintf('mean = %.2f, std = %.2f [%d valeurs]', mean(y), std(y), n),...
    'HorizontalAlignment','left','Rotation',-90,'VerticalAlignment','top','BackgroundColor',[.7 .9 .7]);
axis([0 maxhy miny maxy])
grid

ht = subplot('position',[0.05 0.05 0.3 0.3]);
axis off
text(0,0.95,sprintf('bias (X-Y) = %.2f [%.1f %%]', b, 100*b/mean(y)));
text(0,0.85,sprintf('std (X-Y) = %.2f [%.1f %%]', et,100*et/mean(y)));
text(0,0.75,sprintf('rmse (X-Y) = %.2f [%.1f %%]', eqm,100*eqm/mean(y)));


text(0,0.55,sprintf('correlation coeff. = %.4f', stats(1)^0.5));
text(0,0.45,sprintf('a = %.4f in [%.2f, %.2f] @ 95%%', c(1), cint(1,1), cint(1,2)));
text(0,0.35,sprintf('b = %.4f in [%.2f, %.2f] @ 95%%', c(2), cint(2,1), cint(2,2)));
text(0,0.25,sprintf('residual bias (aX+b-Y)= %.2f [%.1f %%]', mean(r), 100*mean(r)/mean(y)));
text(0,0.15,sprintf('residual std (aX+b-Y)= %.2f [%.1f %%]', std(r),100*std(r)/mean(y)));
text(0,0.05,sprintf('residual rmse (aX+b-Y)= %.2f [%.1f %%]', sqrt(mean(r)^2+std(r)^2),100*sqrt(mean(r)^2+std(r)^2)/mean(y)));

