function [psfr,h] = ssechpsf(psf,r,rayon);


if (nargin == 2)        
    rayon = 16*r;
end

x = [-rayon:rayon];
h = sinc(x/r)/r;
nh = length(h);

h = h.*blackman(nh)';

h = h /sum(h(:));

psfh = conv2(h,h,psf,'full');
psfr = psfh(1:r:end,1:r:end)*r^2;




